// Scilab Code for 1.22
// OS : "Windows 10" , Scilab : 6.0.2 64-bit
clc;
clear;
diary("Ex1_22.txt")
/* Vrms = Vp + 150 m/sec
we know Vrms = (3KbT/m)^(1/2)
        Vp = (2KbT/m)^(1/2)
on squaring and simplifying we get 
T = m*22500/(kb*(5-2*6^(1/2)))  */
// (a) Vrms - Vp = 150 m/sec
m = 32/(6.023*10^26);    //   mass of Oxygen in Kg / mol
kb = 1.38*10^(-23);      //   Boltzmann Constant in J/K
T = m*(22500)/(kb*(5-2*sqrt(6))) ;    // Temperature in Kelvin
disp(" Temperature in Kelvin ;",T)
// (b) Peak of Distribution function for oxygen
Vp = 400     //  Most Probable speed for oxygen in m/sec
T = (m*Vp^2)/(2*kb)   ;  // // Temperature in Kelvin
disp(" Temperature in Kelvin ; ",T)

/* Result


   857.49377

  Temperature in Kelvin ;

   307.99808

  Temperature in Kelvin ;
  
  Answers given in text book are rounded off.
  
   */
