// OS - Windows 10 (64 bit)
// Scilab version - 6.0.2
clear; // Remove clear, clc if you want to access the stored variables 
clc
// Example 37.2  - NC Closed-loop Positioning
// Given that 
x = 75 // Table distance
n_s = 100 // Pulses generated by Optical encoder
p = 5 // Pitch
f_r = 400 // feed rate
r_g = 4 // Gear ratio
n_p = (x*n_s)/p
f_p = (f_r*n_s)/(60*p)
N_ls = f_r/p
N = r_g*N_ls
printf('Pulses received = %.0f pulses\nPulse rate = %.2f Hz\nMotor speed = %.f rev/min',n_p,f_p,N)
