// OS - Windows 10 (64 bit)
// Scilab version - 6.0.2
clear; // Remove clear, clc if you want to access the stored variables 
clc
// Example 28.2 - Welding Travel Speed
// Given that
T_m = 1760 // Melting point temperature from Table 28.2
K = 3.33*10^-6 // Constant when Kelvin scale is used
f1 = 0.7 // Heat transfer factor
f2 = 0.5 // Melting factor
R_h = 3500 // Rate of input energy generated by the welding power source
A_w = 20 // Cross-sectional area in mm^2
U_m = K*T_m^2
v = (f1*f2*R_h)/(U_m*A_w)
printf('The travel speed = %.2f mm/s \n',v)
// Answers may vary due to round of error
