// OS - Windows 10 (64 bit)
// Scilab version - 6.0.2
clear; // Remove clear, clc if you want to access the stored variables 
clc
// Example 29.3 - Heat generation in oxy-acetylene welding
// Given that
Um = 0.3 // Unit energy required to melt the metal
f1 = 0.20 // Heat transfer factor
D = 9 // Work surface diameter
R_H = Um*55*10^6 
R_Hj = R_H/3600 // Rate of heat generated in Joules/sec 
p = 0.75 // 75% heat from the flame
Q = f1*R_Hj // Heat received at the work surface
A = (%pi*(D)^2)/4
PD = (p*Q)/A
printf('The rate of heat generated by the torch = %.0f J/s \nThe rate of heat received at the work = %.0f J/s\n Power density in the circle = %.1f W/mm^2',R_Hj,Q,PD)
