//SCILAB version: 5.5.2
//Operating system: Windows 7 Ultimate
clc;                                //To clear the console screen
clear;                              //To clear all the existing variables in the memory


//Let '1' and '2' be the same naming notations as shown in FIGURE 6-23
//Given data
D=30                                //D is diameter of wind generater blade in 'ft'
V1=7                                //V1 is cut in wind speed in 'mph'
V1_new=14                           //V1_new is new cut in wind speed in 'mph'
W_act=0.4                           //W_act is power generated by the turbine in 'kW'
rho1=0.076                          //rho1 is air density in 'lbm/ft3'


//Unit conversion
V1=V1*1.4667                        //Conversion from 'mph' to 'ft/s'
V1_new=V1_new*1.4667                //Conversion from 'mph' to 'ft/s'
W_act=W_act*1000                    //Conversion from 'kW' to 'W'


//Assumption
betaa=1                             //betaa is momentum flux correction factor


//Part (a)
//Calculation
A1=%pi*D^2/4                        //A1 is the CSA of blade in 'ft2'
m=rho1*V1*A1                        //m is mass flow rate of air in 'lbm/s'
W_max=m*V1^2/2                      //W_max is the maximum power in '(lbm ft2)/s3'
W_max=W_max*0.04214016              //Conversion from '(lbm ft2)/s3' to 'W'
Eta_wind_turbine=W_act/W_max        //Eta_wind_turbine is the efficiency of turbine generator


//Display of result
mprintf('\n(a) Turbine-generator efficiency is %.3f or %.1f Percentage.',Eta_wind_turbine,100*Eta_wind_turbine)


//Part (b)
//Calculation
Rate=V1_new/V1
V2=V1*sqrt(1-Eta_wind_turbine)      //V2 is exit velocity in 'ft/s'
F_R=(m*(V2-V1))                     //F_R is the force excerted on the mast by the wind in '(lbm ft)/s2'
F_R=F_R/32.2                        //Conversion from '(lbm ft)/s2' to 'lbf'
if(F_R<0)
    F_R=abs(F_R)
end
W_act_new=W_act*(Rate^3)            //W_act_new is the new power generated by the turbine in 'W'
F_R_new=F_R*(Rate^2)                //F_R_new is the new force excerted on the mast by the wind in 'lbf'
W_act=W_act/1000                    //Conversion from 'W' to 'kW'
W_act_new=W_act_new/1000            //Conversion from 'W' to 'kW'


//Display of result
mprintf('\n\n(b) Force excerted on the mast by the wind is %.1f lbf.',F_R)
mprintf('\n\nOn increasing the wind velocity by the Rate of %.2f,\nPower generated becomes %.1f kW from %.1f kW.\nForce excerted on the mast by the wind becomes %d lbf from %.1f lbf.',Rate,W_act_new,W_act,F_R_new,F_R)

