// optical fibers and fiber optic communication system
 //Example 7.2
//OS=Windows 10
// // Scilab version 5.5.2(32 b i t )
clc ;
clear 
//given
rc=5*1e-6//radius of core in m
lamdac=1250*1e-9//cutoff wavelength in m
R=1.2*1e-2//radius of curve in m
lamda=1300*1e-9//wavelength in m
meu=1.4469//refractive index at lamda
//to find
dmf=2*rc*(0.65+(0.434*(lamda^1.5/lamdac^1.5))+(0.0149*((lamda^6)/(lamdac^6))))//mode field diameter in um
K=(2*%pi)/lamda//Wave factor
X1=((dmf/2)^6/(8*R^2))//constant for calculation
L=-10*log10(1-((K^4)*(meu^4)*X1))//macrobend loss in dB
mprintf("mode field diameter=%.2fum",dmf*1e6)
mprintf("\npercent loss=%.2f*10^6/m",K/1e6)
mprintf("\nmacrobend loss=%.3fdB",L)
