// optical fibers and fiber optic communication system
 //Example 11.1
//OS=Windows 10
// // Scilab version 5.5.2(32 b i t )
clc ;
clear 
//given
emitting_power=12//in mW of an led
lamda1=850//wavelength in nm
loss1=20//in dB
Responsivity=0.45//in A/W
dark_current=2//in nA
Rl=70//load resistance in ohm
deltaf=10//in MHz
temperature=27+273//in kelvin
loss2=14//in dB
loss3=10//in dB
Total_system_loss=loss1+loss2+loss3;
mprintf("\nTotal_system_loss =%.1fdB",Total_system_loss);//in dB

transmission_efficiency=10^(-Total_system_loss/10)
mprintf("\nThe_transmission_efficiency =%.1fx1e-5",transmission_efficiency*1e5);

Pr=transmission_efficiency*emitting_power//optical power reaching the receiver in W
mprintf("\noptical power reaching the receiver =%.1fx1e-4mW",Pr*1e4);


Ip=Responsivity*Pr*1e-3//Photocurrent in A
mprintf("\nPhotocurrent =%0.0f x1e-0A",Ip*1e9);
//the textbook answer donot match for  last place of decimal due to rounding
Electrical_signal_power=(Ip)^(2)*Rl;//in W
mprintf("\nElectrical_signal_power =%0.2f x1e-12W",Electrical_signal_power*1e12);//in W
//the textbook answer donot match for  last place of decimal due to rounding
k=1.38*10^(-23)//boltman's constant
PTh=4*k*temperature*deltaf*10^(6);//Thermal noise in W
mprintf("\nThermal noise=%0.2f x1e-13W",PTh*1e13);//in W

e=1.6*10^(-19)//charge on an electron in columb
PSN=2*e*Ip*deltaf*Rl*10^(6)//shot noise in W
mprintf("\nshot noise=%0.1f x1e-17W",PSN*1e17);//in W

SNR=Electrical_signal_power/PTh//signal to noise ratio
mprintf("\nsignal to noise ratio=%0.2f ",SNR);
//the textbook answer only donot match for  last place of decimal due to rounding
