//Chapter 15: Antennas for Special Applications
//Example 15-20.1
clc;

//Variable Initialization
Tr = 45     //Satellite receiver temperature (K)
rcp_gain = 6    //Right circularly polarized antenna gain (dBi)
rcp_quad_gain = 3   //RCP gain of quadrifilar helix antenna (dBi)
bandwidth = 9.6e3   //Bandwidth (Hz)
snr = 10        //Required Signal-to-Noise ratio (dB)
c = 3e8     //Speed of light (m/s)
f = 1.65e9  //Frequency (Hz)
r = 780e3   //Distance to the satellite (m)
Ta = 300    //Antenna temperature (K)
k = 1.4e-23 //Boltzmann's constant (J/K)
theta = 10  //Zenith angle (degree)
Tr_handheld = 75    //Hand held receiver temperature (K)
Tsky = 6        //Sky Temperature (K)
theta_horz = 80 //Zenith angle for horizontal dipole (degree)

//Calculations
wave_lt = c/f       //Wavelength (m)
Ld = (wave_lt/(4*%pi*r))**2 //Spatial loss factor(unitless)
Ld_db = 10*log10(Ld)    //Spatial loss factor(dB)
Tsys_up = Ta + Tr      //Satellite system temperature (K)
N = k*Tsys_up*bandwidth    //Noise power(W)
N_db = 10*log10(N)      //Noise power (dB)
E_vert = cos(%pi*cos(theta*%pi/180)/2)/sin(theta*%pi/180)       //Pattern factor for vertical lambda/2 dipole (unitless)
E_vert_db = 20*log10(E_vert)
Pt_vert_up = snr - (2.15 + (E_vert_db) - 3) - rcp_gain + ceil(N_db) - floor(Ld_db)           //Uplink power for vertical lambda/2 antenna (dB)
Pt_vert_up = 10**(Pt_vert_up/10)               //Uplink power for vertical lambda/2 antenna (W)
Ta_down = 0.5*(Ta)+0.5*(Tsky)+3   //Downlink antenna temperature (K)
Tsys_down = Ta_down + Tr_handheld   //System temperature(K)
N_down = k*Tsys_down*bandwidth  //Noise power (W)
N_down_db = 10*log10(N_down)    //Noise power (dB)
Pt_vert_down = snr -(2.15+ (E_vert_db) - 3) -      rcp_gain + ceil(N_down_db) - floor(Ld_db)        //Downlink power for vertical lambda/2 antenna (dB)
Pt_vert_down = 10**(Pt_vert_down/10)         //Downlink power for vertical lambda/2 antenna (W)
E_horz = cos(%pi*cos(theta_horz*%pi/180)/2)/sin(theta_horz*%pi/180)        //Pattern factor for horizontal lambda/2 dipole (unitless)
E_horz_db = (20*log10(E_horz))
Pt_horz_up = snr -(2.15 + E_horz_db - 3) - rcp_gain + round(N_db) - round(Ld_db)          //Uplink power for horizonal lambda/2 dipole (dB)
Pt_horz_up = 10**(Pt_horz_up/10)       //Uplink power for horizonal lambda/2 dipole (W)
Pt_horz_down = snr -(2.15 + E_horz_db - 3) -    rcp_gain + round(N_down_db) - round(Ld_db)          //Downlink power for horizonal lambda/2 dipole (dB)
Pt_horz_down = 10**(Pt_horz_down/10)      //Downlink power for horizonal lambda/2 dipole (W)
Pt_quad_up = snr -(rcp_quad_gain + E_horz_db) -    rcp_gain + round(N_db) - round(Ld_db)          //Uplink power for RCP quadrifilar helix antenna (dB)
Pt_quad_up = 10**(Pt_quad_up/10)      //Uplink power for RCP quadrifilar helix antenna (W)
Ta_quad = 0.85*(Tsky) + 0.15*(Ta) //Downlink antenna temperature (K)
Tsys_quad = Ta_quad + Tr_handheld   //System temperature(K)
N_quad = k*Tsys_quad*bandwidth  //Noise power (W)
N_quad_db = 10*log10(N_quad)    //Noise power (dB)
Pt_quad_down = snr -(rcp_quad_gain + E_horz_db) -  rcp_gain + round(N_quad_db) - round(Ld_db)          //Downlink power for RCP quadrifilar helix antenna (dB)
Pt_quad_down = 10**(Pt_quad_down/10)      //Downlink power for RCP quadrifilar helix antenna (W)


//Results
mprintf("The Uplink power for vertical lambda/2 dipole is %.1f W",Pt_vert_up)
mprintf("\nThe Uplink power for horizontal lambda/2 dipole is %.3f W",Pt_horz_up)
mprintf("\nThe Uplink power for RCP quadrifilar helix antenna is %.3f W",Pt_quad_up)
mprintf("\nThe Downlink power for vertical lambda/2 dipole is %.1f W",Pt_vert_down)
mprintf("\nThe Downlink power for horizontal lambda/2 dipole is %.3f W",Pt_horz_down)
mprintf("\nThe Downlink power for RCP quadrifilar helix antenna is %.3f W",Pt_quad_down)
