//Fluid Systems - By - Shiv Kumar
//Chapter 11- Centrifugal Pumps
//Example 11.20
//To Determine       (i)Head generated by the Pump          (ii)Shaft Power required to run the Pump.

          clc
          clear

//Given Data:-
      n=3;           //Number of Stages 
      Do=400;           //Diameter of the Impeller at Outlet, mm
      bo=20;           //Width of Impeller at outlet, mm
      beta_o=45;      //degrees
      Area_per=10;         //Percentage of Total Area which is reduced.
      eta_o=80/100;        //Overall Efficiency
      eta_man=90/100;          //Manometric Efficiency
      N=1000;            //Speed, rpm
      Q=0.05;           //Discharge, m^3/s


//Data Used: -
          rho=1000;               //Density of water, kg/m^3
         g=9.81;       //Acceleration due to gravity, m/s^2
        

//Computations:-
            Do=Do/1000;        //m
            bo=bo/1000;        //m
           A=%pi*Do*bo*(1-Area_per/100);          //Actual Area of Flow, m^2

             uo=%pi*Do*N/60;         //Tangential Velocity of Impeller at Outlet, m/s
             Vfo=Q/A;         //Velocity of Flow, m/s
             Vfi= Vfo; 
             Vwo=uo-Vfo/tand(beta_o);      //m/s  (Value given in book is wrong due to incorrect value of beta_o is used)

      // (i)Head generated by the Pump , H_Tm
              Hm=eta_man*Vwo*uo/g;        //m
              H_Tm=n*Hm;          //m

       //(ii) Shaft Power required to run the Pump , P
                 P=rho*Q*g*H_Tm/(eta_o*1000);         //kW


//Results:-
          printf(" (i)Head generated by the Pump , H_Tm=%.2f m \n",H_Tm)     //The answer provided in the textbook is wrong
          printf(" (ii) Shaft Power required to run the Pump , P =%.2f kW \n",P)     //The answer provided in the textbook is wrong


