// Example 34_9
clc;funcprot(0);
//Given data
L=60;// MW
L_0=0;// Zero load in MW
// I=5*10^6*(8+8*L+0.4L^2)
T_f=20;// Time in hours
T_0=4;// Time in hours

// Calculation
E_g=(T_f*L)+(T_0*0);// Total energy generated by the power plant during 24 hoursbin MWh
I_60=5*10^6*(8+(8*L)+(0.4*L^2))*20;// Input to the plant when the plant is running at full load in kJ
I_0=5*10^6*(8+(8*L_0)+(0.4*L_0^2))*20;// Input at no load in kJ
Ti=I_60+I_0;// Total input to the plant during 24 hours in kJ/day
Q=Ti/(E_g*10^3);// Average heat supplied per kWh generated in kJ/kWh
L_a=E_g/24;// Average load in MW
I_50=5*10^6*(8+(8*L_a)+(0.4*L_a^2))*24;// Heat supplied during 24 hours in kJ/day
Ns=Ti-I_50;// Net saving per day in kJ/day
S=Ns/(E_g*10^3);// Saving per kWh
printf('\nThe heat input per day to the power station=%0.5e kJ/day \nSaving per kWh=%0.0f kJ/kWh',I_50,S);
// The answer provided in the textbook is wrong
