// Example 32_27
clc;funcprot(0);
//Given data
T=[0 2 3 6 8 12 14 15 17 23 24];// Time in hours 
L=[1200 2000 3000 1500 2500 1800 2000 1000 500 800];//  Load in kW 

//Calculation
T_p=[0 0 2 2 3 3 6 6 8 8 12 12 14 14 15 15 17 17 23 23 24 24];// Time in hours for load curve
L_p=[3200 1200 1200 2000 2000 3000 3000 1500 1500 2500 2500 1800 1800 2000 2000 1000 1000 500 500 800 800 200];//  Load in kW for load curve
xlabel('Time (hours)');
ylabel('LOAD (kW)');
xtitle('Fig.32.27 Load curve');
plot(T_p,L_p,'b')
a=gca();
a.x_ticks.labels=["6 A.M","8","10","12 NOON","2","4","6","8","10","12 NIGHT","2","4","6 A.M "];
a.x_ticks.locations=[0;2;4;6;8;10;12;14;16;18;20;22;24];
//(a)
E_t=(L(1)*(T(2)-T(1)))+(L(2)*(T(3)-T(2)))+(L(3)*(T(4)-T(3)))+(L(4)*(T(5)-T(4)))+(L(5)*(T(6)-T(5)))+(L(6)*(T(7)-T(6)))+(L(7)*(T(8)-T(7)))+(L(8)*(T(9)-T(8)))+(L(9)*(T(10)-T(9)))+(L(10)*(T(11)-T(10)));// Total power generated in kW-hrs
L_max=L(3);// Maximum load in kW
LF=E_t/(L_max*24);// Load factor
//(b)
L_1=1200;// kW
L_2=800;// kW
L_3=2*500;// kW
L_4=300;// kW
//(c)
Rc=1200;// Reserve capacity in MW
Ic=L_1+L_2+L_3+L_4+Rc;// Installed capacity in kW
CF=(E_t/(Ic*24))*100;// Plant capacity factor
//(d)
L_1=1200;// kW
L_2=800;// kW
L_3=500;// kW
L_4=300;// kW
E=(L_1*17)+(L_2*11)+(L_3*3)+(L_3*7)+(L_3*7)+(L_4*3);// The energy generated by the capacity of the plant in kW-hrs;
UF=(E_t/E)*100;// Plant use factor
printf('\n(a)Load factor=%0.3f \n(b)It is obvious from the load curve that the numberof sets required are 5 in number \n   One set of 1200 kW \n   One set of 800 kW \n   Two sets of 500 kW \n   One set of 300 kW \n(c)The reserve capacity of the plant=%0.0f kW \n   Capacity factor=%0.0f percentage \n(d)Plant use factor=%0.0f percentage',LF,Rc,CF,UF);
