// Example 3_4
clc;funcprot(0);
//Given data
L=[60 120 40 10];// Load in MW
T_1=[6,10];// Time in hours
T_2=[10,18];// Time in hours
T_3=[18,24];// Time in hours
T_4=[0,6];// Time in hours
Er=1.5;// Rs/kW-hr
c=2.2;// Cost of input in rupees
n_th=[35 40 30 20]/100;
Q=20000;// kJ
n_thb=40/100;// Thermal efficiency
n_o=80/100;// Over all efficiency of pump storage plant

// Calculation
//(a)
T_p=[0 0 4 4 12 12 18 18 24 24];// Time in hours
L_p=[0 60 60 120 120 40 40 10 10 130];// Load in MW
plot(T_p',L_p','b');
a=gca();
a.x_ticks.labels=["6 P.M","","","12 P.M","","","6 P.M","","","12 P.M","","","6 P.M"];
a.x_ticks.locations=[0;2;4;6;8;10;12;14;16;18;20;22;24];
O=((L(1)*(T_1(2)-T_1(1)))+(L(2)*(T_2(2)-T_2(1)))+(L(3)*(T_3(2)-T_3(1)))+(L(4)*(T_4(2)-T_4(1))))*10^3;// Total energy generated by the thermal plant
Tc_s=Er*O;// Total cost of selling the power in rupees
I= (((L(1)*(T_1(2)-T_1(1)))/(n_th(1)))+((L(2)*(T_2(2)-T_2(1)))/(n_th(2)))+((L(3)*(T_3(2)-T_3(1)))/(n_th(3)))+((L(4)*(T_4(2)-T_4(1)))/(n_th(4))))*10^3;// Total input to the thermal plant in kWh
Tc_i=c*(1/(Q))*(I*3600);// Total cost of input energy in rupees
Nr_1=Tc_s-Tc_i;// Net revenue earned in Rs./day

//(b)
function[Y]=baseload(x)
    Y(1)=((((x(1)-L(3))*(T_3(2)-T_3(1)))+((x(1)-L(4))*(T_4(2)-T_4(1)))+((x(1)-L(1))*(T_1(2)-T_1(1))))*(n_o))-((L(2)-x(1))*(T_2(2)-T_2(1)));
   endfunction
x=[10];
z=fsolve(x,baseload);
x=(z(1));// The capacity of the thermal plant in MW
X=[x x x x x x x x x x];// // The capacity of the thermal plant in MW for plot
xlabel('Time in hrs');
ylabel('Load in MW');
plot(T_p',L_p','b',T_p',X','b-.');
legend('Load curve','Base load thermal plant');
Ti=((x*24)/n_thb)*3600;// Total input to the thermal plant in 24 hours in MJ
Tc_i=Er*(1/Q)*Ti*10^3;// Total cost of input energy during 24 hours in rupees
Nr_2=Tc_s-Tc_i;// // Net revenue earned from the combined plant in Rs./day
P=((Nr_2-Nr_1)/(Nr_1))*100;// Percentage increase in the profit
printf('\n(a)The net revenue earned if the load is taken by the single thermal power plant=%0.3e rupees per day \n(b)The capacity of the thermal plant=%0.0f MW \n   Percentage increase in the revenue earned=%0.1f percentage',Nr_1,x,P);
