// Example 35_4
clc;funcprot(0);
//Given data
// C_1=100*10^4+ 600 kW+0.1 kWh
// C_2=60*10^4+ 350 kW+0.2 kWh
A_1=600;
A_2=350;
B_1=0.1;
B_2=0.2;
t=8760;// hours

// Calculation
// C=[100*10^4+600x+0.1S_a]+[60*10^4+350*(P-x)+0.2*(S_t-S_a)];
//  The required condition is dC/dx=0;
// dS_a=2500dx;....(a)
// From Fig.Prob.35.4(b)
// dS=H.dx;....(b)
H=2500;// hrs
// From similar triangles oab and dcb
ob=50000;// kW
L_b=ob;// kW
db=(H*ob)/t;// Installed capacity for station B in kW
S_b=(1/2)*db*H;// Units generated by station B
oa=t;// hours
S_t=(1/2)*ob*oa;// Total units generated in kWh
S_a=S_t-S_b;// Units generated by station A
L_a=ob-db;// kW
C_a=100*10^4+(A_1*L_a)+(0.1*S_a);// rupees
C_b=60*10^4+(A_2*ob)+(0.1*S_b);// rupees
C=C_a+C_b;// rupees
Gc=(C/S_t)*100;// Overall cost of generation in paise/kWh
printf('\nOverall cost of generation=%0.1f paise/kWh',Gc);
// The answer vary due to round off error
