//Example 7.30
// Full-Order Compensator Design for DC Servo.

xdel(winsid())//close all graphics Windows
clear;
clc;
//------------------------------------------------------------------

// State space representation
//Transfer function model for DC Servo
s=poly(0,'s');
num=10;
den=s*(s+2)*(s+8);
Gs=syslin('c',num/den);

// State space representation
F=[-10 1 0;-16 0 1;0 0 0];
G=[0 0 10]';
H=[1 0 0];
J=0;
n=sqrt(length(F));
//Desired poles for the DC Servo system.
Pc=[-1.42 -1.04+2.14*%i -1.04-2.14*%i ]


// State feedback gain
K=ppol(F,G,Pc)
disp(K,'K=',"State feedback gain")

//Estimator - error roots are at
Pe=[-4.25 -3.13+6.41*%i -3.13-6.41*%i]
L=ppol(F',H',Pe);
L=L';
disp(L,'L=',"Observer gain")
//------------------------------------------------------------------
//Compensator Design
DK=-K*inv(s*eye(n,n)-F+G*K+L*H)*L;

exec('./zpk_dk.sci', -1);
[p,z]=zpk_dk(DK);
D=poly(z,'s','roots')/poly(p,'s','roots')

evans(Gs*D)
zoom_rect([-8 -9 3 9])

f=gca();
f.x_location = "origin"
f.y_location = "origin"
xset("color",2);
h=legend('');
h.visible = "off"

//Title, labels and grid to the figure
exec .\fig_settings.sci; // custom script for setting figure properties
title('Root locus for DC servo pole assignment','fontsize',3);
//------------------------------------------------------------------

















