
// Variable Declaration
kv = 13.2       //Voltage rating of generator(kV)
MVA = 25.0      //MVA rating of generator
MVA_sc = 170.0  //Short circuit MVA
x0 = 0.05       //Zero sequence reactance(p.u)
x2 = 0.13       //Negative sequence reactance(p.u)

MVA_base = 25.0                                 //Base MVA
kv_base = 13.2                                  //Line-to-line Base voltage(kV)
I_base = MVA_base*1000/(3**0.5*kv_base)         //Base current(A)
x1 = MVA_base/MVA_sc                            //Positive sequence reactance(p.u)
V_f = 1.0                                       //Pre-fault terminal voltage(p.u)
Z_f = 0                                         //Fault impedance
a = 1.0*exp(%i*120*%pi/180)          //Operator

// Calculation Section
I_a1 = V_f/complex(0,(x0+x1+x2))                //Positive sequence current(p.u)
I_a2 = I_a1                                     //Negative sequence current(p.u)
I_a0 = I_a1                                     //Zero sequence current(p.u)
I_a = 3*I_a1*I_base                             //Fault current at phase a(A)
I_b = 0                                         //Fault current at phase b(A)
I_c = 0                                         //Fault current at phase c(A)
V_a1 = V_f - I_a1*complex(0,x1)                 //Terminal voltage(p.u)
V_a2 = -I_a2*complex(0,x2)                      //Terminal voltage(p.u)
V_a0 = -I_a0*complex(0,x0)                      //Terminal voltage(p.u)
V_a = (V_a0+V_a1+V_a2)*kv_base/3**0.5           //Line-to-neutral voltage at terminal(kV)
V_b = (V_a0+a**2*V_a1+a*V_a2)*kv_base/3**0.5    //Line-to-neutral voltage at terminal(kV)
V_c = (V_a0+a*V_a1+a**2*V_a2)*kv_base/3**0.5    //Line-to-neutral voltage at terminal(kV)
V_ab = (V_a-V_b)                                //Line voltages at terminal(kV)
V_bc = (V_b-V_c)                                //Line voltages at terminal(kV)
V_ca = (V_c-V_a)                                //Line voltages at terminal(kV)

I_a12 = V_f/complex(0,(x1+x2))                    //Positive sequence current(p.u)
I_a22 = -I_a12                                    //Negative sequence current(p.u)
I_a02 = 0                                         //Zero sequence current(p.u)
I_a_2 = (I_a12+I_a22+I_a02)*I_base                //Fault current at phase a(A)
I_b_2 = (a**2*I_a12+a*I_a22+I_a02)*I_base         //Fault current at phase b(A)
I_c_2 = -I_b_2                                    //Fault current at phase c(A)
V_a12 = V_f - I_a12*complex(0,x1)                 //Terminal voltage(p.u)
V_a22 = V_a12                                     //Terminal voltage(p.u)
V_a02 = 0                                         //Terminal voltage(p.u)
V_a_2 = (V_a02+V_a12+V_a22)*kv_base/3**0.5        //Line-to-neutral voltage at terminal(kV)
V_b_2 = (V_a02+a**2*V_a12+a*V_a22)*kv_base/3**0.5 //Line-to-neutral voltage at terminal(kV)
V_c_2 = (V_a02+a*V_a12+a**2*V_a22)*kv_base/3**0.5 //Line-to-neutral voltage at terminal(kV)
V_ab2 = (V_a_2-V_b_2)                             //Line voltages at terminal(kV)
V_bc2 = (V_b_2-V_c_2)                             //Line voltages at terminal(kV)
V_ca2 = (V_c_2-V_a_2)                             //Line voltages at terminal(kV)

I_a13 = V_f/complex(0,(x1+(x0*x2/(x0+x2))))       //Positive sequence current(p.u)
I_a23 = -I_a13*x0/(x0+x2)                         //Negative sequence current(p.u)
I_a03 = -I_a13*x2/(x0+x2)                         //Zero sequence current(p.u)
I_a_3 = (I_a13+I_a23+I_a03)*I_base                //Fault current at phase a(A)
I_b_3 = (I_a03+a**2*I_a13+a*I_a23)*I_base         //Fault current at phase b(A)
I_c_3 = (I_a03+a*I_a13+a**2*I_a23)*I_base         //Fault current at phase c(A)
V_a13 = V_f-I_a13*complex(0,x1)                   //Terminal voltage(p.u)
V_a23 = V_a13                                     //Terminal voltage(p.u)
V_a03 = V_a13                                     //Terminal voltage(p.u)
V_a3 = (V_a03+V_a13+V_a23)*kv_base/3**0.5         //Line-to-neutral voltage at terminal(kV)
V_b3 = (V_a03+a**2*V_a13+a*V_a23)*kv_base/3**0.5  //Line-to-neutral voltage at terminal(kV)
V_c3 = (V_a03+a*V_a13+a**2*V_a23)*kv_base/3**0.5  //Line-to-neutral voltage at terminal(kV)
V_ab3 = (V_a3-V_b3)                               //Line voltages at terminal(kV)
V_bc3 = (V_b3-V_c3)                               //Line voltages at terminal(kV)
V_ca3 = (V_c3-V_a3)                               //Line voltages at terminal(kV)


// Result Section
printf('Case(i) : L-G fault :')
printf('Short circuit current , I_a  = %.1fj A = %.1f∠%.f° A' ,imag(I_a),abs(I_a),phasemag(I_a))
printf('Short circuit current , I_b  = %.f∠%.f° A' ,abs(I_b),phasemag(I_b))
printf('Short circuit current , I_c  = %.f∠%.f° A' ,abs(I_c),phasemag(I_c))
printf('Terminal line voltage , V_ab = %.2f∠%.2f° kV' ,abs(V_ab),phasemag(V_ab))
printf('Terminal line voltage , V_bc = %.2f∠%.2f° kV' ,abs(V_bc),phasemag(V_bc))
printf('Terminal line voltage , V_ca = %.2f∠%.2f° kV' ,abs(V_ca),phasemag(V_ca))
printf('\nCase(ii) : L-L fault :')
printf('Short circuit current , I_a  = %.f∠%.f° A' ,abs(I_a_2),phasemag(I_a_2))
printf('Short circuit current , I_b  = %.2f∠%.1f° A' ,abs(I_b_2),phasemag(I_b_2))
printf('Short circuit current , I_c  = %.2f∠%.1f° A' ,abs(I_c_2),phasemag(I_c_2))
printf('Terminal line voltage , V_ab = %.3f∠%.1f° kV' ,abs(V_ab2),phasemag(V_ab2))
printf('Terminal line voltage , V_bc = %.f∠%.1f° kV' ,abs(V_bc2),phasemag(V_bc2))
printf('Terminal line voltage , V_ca = %.3f∠%.1f° kV' ,abs(V_ca2),phasemag(V_ca2))
printf('\nCase(iii) : L-L-G fault :')
printf('Short circuit current , I_a  = %.f∠%.f° A' ,abs(I_a_3),phasemag(I_a_3))
printf('Short circuit current , I_b  = %.2f∠%.1f° A' ,abs(I_b_3),phasemag(I_b_3))
printf('Short circuit current , I_c  = %.2f∠%.1f° A' ,abs(I_c_3),phasemag(I_c_3))
printf('Terminal line voltage , V_ab = %.3f∠%.f° kV' ,abs(V_ab3),phasemag(V_ab3))
printf('Terminal line voltage , V_bc = %.f∠%.f° kV' ,abs(V_bc3),phasemag(V_bc3))
printf('Terminal line voltage , V_ca = %.3f∠%.f° kV' ,abs(V_ca3),phasemag(V_ca3))
printf('\nNOTE : Changes in answer is due to more decimal places')
