Na = 10^18;
Nd = 5*10^15;
ni = 1.5*10^10;
kT = 0.0259;
epsilon0 = 8.85*10^-14;
epsilon = 11.8;
q = 1.6*10^-19;
E1 = kT*log(Na/ni);
E2 = kT*log(Nd/ni);
qV1 = E1+E2;
qV2 = kT*log(Na*Nd/ni^2);
d = 10*10^-4; //in centimetre
A = %pi*d^2/4;
W = sqrt(2*epsilon*epsilon0*qV1/q *(Na^-1 + Nd^-1));
xn0 = W/(1+(Nd/Na));
xp0 = W/(1+(Na/Nd)); 
Q = q*A*xn0*Nd;
E0 = -q*xn0*Nd/(epsilon*epsilon0);
disp(W*10^4,"width of the transition region(in micron)=")
disp(xn0*10^4,"penetration of the space charge region into the n material (in micron)=")
disp(xp0*10^4,"penetration of the space charge region into the p material (in micron)=")
disp(Q,"total uncompensated charge (in coulomb)=")
disp(E0,"maximum electric field(in V per cm)=")