clear;
clc;
disp('Example 8.15');

//  aim : To determine
//  (a) the mass of coal used per hour
//  (b) the mass of air used per hour
//  (c) the percentage analysis of the flue gases by mass

//  given values
m = 900;// mass of steam boiler generate/h, [kg]
x = .96;// steam dryness fraction
P = 1400;// steam pressure, [kN/m^2]
Tf = 52;// feed water temperature, [C]
BE = .71;// boiler efficiency
CV = 33000;// calorific value  of coal, [kJkg[
ea = .22;// excess air supply
aO2 = .23;// oxygen composition in air
c = 4.187;// specific heat capacity of water, [kJ/kg K]

//  coal composition
C = .83;// mass composition of carbon
H2 = .05;// mass composition of hydrogen
O2 = .03;// mass composition of oxygen
ash = .09;// mass composition of ash

// solution
// from steam table at pressure P
hf = 830.1;// specific enthalpy, [kJ/kg]
hfg = 1957.1;// specific enthalpy, [kJ/kg]
hg = 2728.8;// specific enthalpy, [kJ/kg]

// (a)
h = hf+x*hfg;// specific enthalpy of steam generated by boiler, [kJ/kg]
hfw = c*Tf;// specific enthalpy of feed water, [kJ/kg]
Q = m*(h-hfw);// energy to steam/h, [kJ]
Qf = Q/BE;// energy required from fuel/h, [kJ]
mc = Qf/CV;// mass of coal/h,[kg]
mprintf('\n (a) The mass of coal used per hour is  =  %f kg\n',mc);

// (b)
// for one kg coal
mO2 = 8/3*C+8*H2+-O2;// actual mass of O2 required, [kg]
mta = mO2/aO2;// theoretical mass of air, [kg]
ma = mta*(1+ea);// mass of air supplied, [kg]
mas = ma*mc;// mass of air supplied/h, [kg]
mprintf('\n (b) The mass of air supplied per hour is  =  %f kg\n',mas);

 
// (c)
// for one kg coal
mCO2 = 11/3*C;// mass of CO2 produced, [kg]
mH2O = 9*H2;// mass of H2O produced, [kg]
mO2 = mO2*ea;// mass of excess O2 in flue gas, [kg]
mN2 = ma*(1-aO2);// mass of N2 in flue gas, [kg]

mt = mCO2+mH2O+mO2+mN2;// total mass of gas
x1 = mCO2/mt*100;// mass percentage composition of CO2
x2 = mH2O/mt*100;// mass percentage composition of H2O
x3 = mO2/mt*100;// mass percentage composition of O2
x4 = mN2/mt*100;// mass percentage composition of N2

mprintf('\n (c) The mass percentage composition of CO2  =  %f,\n      The mass percentage composition of H2O  =  %f,\n      The mass percentage composition of O2  =  %f,\n      The mass percentage composition of N2  =  %f',x1,x2,x3,x4);

//  mass of coal taken in part (b) is wrong so answer is not matching

//  End



