//Variable declaration:
Dz = 3000                       //Height (ft)
V0 = 500000                     //Flowrate of water (gal/min)
n = 30                          //Turbine efficiency (%)
m = 0.3048                      //Meters in a feet
m3 = 0.00378                    //Meters-cube in a gallon
g = 9.8                         //Gravitational acceleration (m/s^2)
gc = 1                          //Conversion factor
MW = 10**(-6)                   //Megawatt in newton-meter-per-second

//Calculations:
V1 = (V0*m3)*1000.0/60.0        //The mass flow rate of the water in kilograms/second (kg/s)
DPE = V1*g*Dz*m/gc*MW           //The loss in potential energy (MW)
AP = n/100.0*DPE                //The actual power output (MW)

//Result:
printf ("The power generated by the lake located is : %.1f MW",AP)
