//Variable declaration:
r1 = 1.1/100                    //Inside radius of %pipe (m)
r2 = 1.3/100                    //Outside radius of %pipe (m)
r3 = 3.8/100                    //Outside radius of asbestos insulation (m)
L = 1                           //Length of tube (m)
h1 = 190                        //Heat transfer coefficient from ethylene glycol to the stainless steel %pipe (W/m^2.K)
k2 = 19                         //Thermal conductivity of %pipe (W/m.K)
h2 = 14                         //Outside heat transfer coefficient from the air to the surface of the insulation (W/m^2.K)
k3 = 0.2                        //Thermal conductivity of asbestos (W/m.K)
T1 = 124                        //Hot ethylene glycol temperature ( C)
T5 = 2                          //Surrounding air temperature ( C)
k4 = 0.0242                     //Thermal conductivity of air (W/m.K)

//Calculation:
A1 = 2*%pi*r1*L                  //Inside surface area of %pipe (m^2) (part1)
A2 = 2*%pi*r2*L                  //Outside surface area of %pipe (m^2)
A3 = 2*%pi*r3*L                  //Outside surface area of asbestos insulation (m^2)
R1 = 1/(h1*A1)                  //Inside convection resistance ( C/W)
R2 = log(r2/r1)/(2*%pi*k2*L)     //Conduction resistance through the tube ( C/W)
R3 = 1/(h2*A2)                  //Outside convection resistance ( C/W)
Rt1 = R1+R2+R3                  //Total resistance without insulation ( C/W)
Q1 = (T1 - T5)/Rt1              //Heat transfer rate without insulation (W)
R4 = log(r3/r2)/(2*%pi*k3*L)     //Conduction resistance associated with the insulation ( C/W) (part 2)
R5 = 1/(h2*A3)                  //Outside convection resistance ( C/W)
Rt2 = R1+R2+R4+R5               //Total rsistance with the insulation ( C/W)
Q2 = (T1-T5)/Rt2                //Heat transfer rate with the insulation (W)
U1 = 1/(Rt2*A1)                 //Overall heat transfer coefficient based on the inside area (W/m^2.K) (part 3)
U3 = 1/(Rt2*A3)                 //Overall heat transfer coefficient based on the outside area (W/m^2.K) (part 4)
T3 = T1-(R1+R2)*Q2              //Temperature at the steelu2013insulation interface ( C) (part 5)
Bi1 = h2*(2*r3)/k3              //Outside Biot number (part 6)
Bi2 = h1*(2*r1)/k2              //Inside Biot number
Nu = h1*(2*r1)/k4               //Nusselt number of the air
rlm = (r3-r2)/log(r3/r2)        //Log mean radius of the insulation (m) (part 7)

//Result:
printf("1. The rate of heat transfer without insulation is : %.1f W.",Q1)
printf("2. The rate of heat transfer with insulation is : %.1f W.",Q2)
printf("3. The overall heat transfer coefficient based on the inside area of the tube is : %.2f W/m^2.K .",U1)
printf("4. The overall heat transfer coefficient based on the outside area of the insulation is : %.1f W/m^2.K .",U3)
printf("5. The temperature, T3, at the steelu2013insulation interface is : %.1f C.",T3)
printf("6. The inside Biot numbers is : %.2f",Bi2)
printf("   The outside Biot numbers is : %.2f",Bi1)
printf("   The Nusselt number is : %.1f",Nu)
printf("7. The log mean radius of insulation is : %.2f cm.",rlm*100)
printf("There is a printing mistake in book for unit in part 7.")
