
theta=linspace(0,2*%pi,100)
i=50*sin(theta)
xset('window',0)
plot2d(theta,i)
xtitle("Current wave shape for example 6.8-->(a)","theta","current")

xset('window',1)
theta=linspace(0,%pi,100)
i=50*sin(theta)
plot2d(theta,i)
theta=linspace(%pi,2*%pi,100)
i=-50*sin(theta)
plot2d(theta,i)
xtitle("Current wave shape for example 6.8-->(b)","theta","current")

xset('window',2)
theta=linspace(0,0,2)
i=linspace(0,50,2)
plot2d(theta,i)
theta=linspace(0,%pi,2)
i=linspace(50,50,2)
plot2d(theta,i)
theta=linspace(%pi,%pi,2)
i=linspace(50,-50,2)
plot2d(theta,i)
theta=linspace(%pi,2*%pi,2)
i=linspace(-50,-50,2)
plot2d(theta,i)
i=linspace(-50,0,2)
theta=linspace(2*%pi,2*%pi,2)
plot2d(theta,i)
xtitle("Current wave shape for example 6.8-->(c)","theta","current")

xset('window',3)
theta=linspace(0,%pi/2,2)
i=linspace(0,50,2)
plot2d(theta,i)
theta=linspace(%pi/2,%pi,2)
i=linspace(50,0,2)
plot2d(theta,i)
theta=linspace(%pi,3*%pi/2,2)
i=linspace(0,-50,2)
plot2d(theta,i)
theta=linspace(3*%pi/2,2*%pi,2)
i=linspace(-50,0,2)
plot2d(theta,i)
xtitle("Current wave shape for example 6.8-->(d)","theta","current")

//consider wave shape (a)
mprintf("For wave shape (a)\nAs the negative and positive parts of the wave are equal, reading of moving coil ammeter is zero\n")
Irms=sqrt(integrate('(50*sin(theta))^2','theta',0,2*%pi)/(2*%pi))
mprintf("Reading of moving iron ammeter=%f A\n",Irms)

//consider wave shape (b)
Iavg=integrate('50*sin(theta)','theta',0,%pi)/%pi
mprintf("For wave shape (b)\nReading on the moving coil ammeter=%f A\n",Iavg)
Irms=sqrt(integrate('(50*sin(theta))^2','theta',0,2*%pi)/(2*%pi))
mprintf("Reading on moving iron ammeter=%f A\n",Irms)

//consider case (c)
mprintf("For wave shape (c)\nAverage value over one complete period is clearly zero. Thus reading on moving coil ammeter is zero. As the value of current remains constant at 50 A during various intervals, RMS value will be 50 A only. Hence, reading on moving iron ammeter=50 A\n")

//consider case(d)
Iavg=(0+10+20+30+40+50++40+30+20+10+0+(-10)+(-20)+(-30)+(-40)+(-50)+(-40)+(-30)+(-20)+(-10)+0)/20
mprintf("For wave shape (d)\nReading on moving coil ammeter=%d\n",Iavg)
Irms=sqrt((0^2+10^2+20^2+30^2+40^2+50^2+40^2+30^2+20^2+10^2+0^2+(-10)^2+(-20)^2+(-30)^2+(-40)^2+(-50)^2+(-40)^2+(-30)^2+(-20)^2+(-10)^2+0^2)/20)
mprintf("Reading on moving iron ammeter=%f A\n",Irms)
