// scilab Code Exa 18.9 Constant Pressure Gas Turbine Plant

T1=298; // Minimum Temperature in Kelvin
beeta=4.5; // Maximum to Minimum Temperature ratio(T_max/T_min)
m=115; // mass flow rate through the turbine and compressor in kg/s
n_C=0.79; // Compressor Efficiency
n_T=0.83; // Turbine Efficiency
gamma_g=1.33;
R=0.287;
cp=(gamma_g/(gamma_g-1))*R; // Specific Heat at Constant Pressure in kJ/(kgK)
alpha=beeta*n_C*n_T;
t_opt=sqrt(alpha); // For maximum power output, the temperature ratios in the turbine and compressor

// part(a) Determining optimum pressure ratio of the plant
r=t_opt^(gamma_g/(gamma_g-1));
disp(r,"(a)optimum pressure ratio of the plant is")

// part(b)Carnot's efficiency
n_Carnot=1-(1/beeta);
disp("%",n_Carnot*100,"(b)Carnot efficiency of the plant is")

// part(c) Determining Joule's cycle efficiency
n_Joule=1-(1/t_opt);
disp("%",n_Joule*100,"(c)efficiency of the Joule cycle is")

// part(d) Determining thermal efficiency of the plant for maximum power output
n_th=(t_opt-1)^2/((beeta-1)*n_C-(t_opt-1));
disp("%",n_th*100,"(d)thermal efficiency of the plant for maximum power output is")

// part(e) Determining power output
wp_max=cp*T1*((t_opt-1)^2)/n_C; // maximum work output
P_max=m*wp_max;
disp ("MW",P_max/1e3,"(e)Power output is")

// part(f) Determining power generated by the turbine required to drive the compressor
T3=beeta*T1;  // Maximum Temperature in degree K
T4s=T3*(r^(-((gamma_g-1)/gamma_g)));
T4=T3-((T3-T4s)*n_T);
P_T=m*cp*(T3-T4);
disp ("MW",P_T/1e3,"(f)Power generated by the turbine is")

// part(g) Determining power absorbed by the compressor
T2s=T1*(r^((gamma_g-1)/gamma_g));
T2=T1+((T2s-T1)/n_C);
P_C=m*cp*(T2-T1);
disp ("MW",P_C/1e3,"(g)Power absorbed by the compressor is")

//part(h)heat supplied in the combustion chamber
Qs=m*cp*(T3-T2);
disp("MW",Qs/1e3,"(h)heat supplied in the combustion chamber is")
