//CHAPTER 2,ILLUSTRATION 8 PAGE 62
//TITLE:TRANSMISSION OF MOTION AND POWER BY BELTS AND PULLEYS
clc
clear
//INPUT
t=9//THICKNESS IN mm
b=250//WIDTH IN mm
D=90//DIAMETER OF PULLEY IN cm
N=336//SPEED IN rpm
PI=3.141
U=.35//COEFFICIENT FRICTION
e=2.71
THETA=120*PI/180
Fb=2//STRESS IN MPa
d=1000//DENSITY IN KG/M^3

//CALCULATION
M=b*10^-3*t*10^-3*d//MASS IN KG
V=PI*D*10^-2*N/60//VELOCITY IN m/s
Tc=M*V^2//CENTRIFUGAL TENSION
Tmax=b*t*Fb//MAX TENSION IN N
T1=Tmax-Tc
T2=T1/(e^(U*THETA))
P=(T1-T2)*V/1000

//OUTPUT
printf('THE TENSION ON TIGHT SIDE OF THE BELT IS %f N\n',T1)
printf('THE TENSION ON SLACK SIDE OF THE BELT IS %f N\n',T2)
printf('CENTRIFUGAL TENSION =%f N\n',Tc)
printf('THE POWER CAPACITY OF BELT IS %f KW\n',P)

