//Example 9.12
clc
disp("For the Schmitt trigger")
disp("V_UT = 2 V,    V_LT = -4 V,    +-V_sat = +-10 V")
disp("For unequal UTP and LTP values, a modified circuit is required as shown in the fig.9.52.")
disp("The voltage V1 decides the UTP and LTP levels. Applying KVL to the output circuit and neglecting op-amp input current we can write,")
disp("-IR2 - IR1 - x + V0 = 0")
disp("Therefore,  I = V0-x / R1+R2")
disp("And  V1 = IR1 + x")
disp("Therefore,  V1 = (V0-x/R1+R2)*R1 + x")
disp("For    +V_sat = 10 V,")
disp("V1 = V_UT = 2 V,")
disp("V0 = 10 V")
disp("Therefore,  2 = (10-x/R1+R2)*R1 + x      (1)")
disp("For -V_sat = -10 V,")
disp("V1 = V_LT = -4 V,")
disp("V0 = -10 V")
disp("Therefore,  -4 = (-10-x/R1+R2)*R1 + x     (2)")
disp("Subtracting equations (2) and (1),")
disp("Therefore,  6 = 20*R1 / R1+R2")
disp("Therefore,  R1+R2 = 3.333*R1")
disp("Therefore,  R2 = 2.333*R1      (3)")
disp("Substituting (3) in equation (1)")
disp("2 = ((10-x)*R1 / 3.333*R1) + x")
disp("Therefore,  2.333*x = -3.3334")
x=-3.3334/2.333
format(7)
disp(x,"Therefore,  x =")
disp("So actually polarity of the voltage source ''x'' must be opposite to what is assumed earlier as shown in fig.9.52.")
disp("Choose    R1 = 1 k-ohm    hence  R2 = 2.333 k-ohm")
disp("Therefore,  R_comp = R1 || R2 = 0.7 k-ohm")
disp("Now as long as V_in is less than V_UT, the output is at +V_sat = 10 V and when V_in > V_UT, the output switches from +V_sat to -V_sat. While as long as V_in > V_LT, the output is at -V_sat = -10 V and when V_in < V_LT, the output switches from -V_sat to +V_sat.")
