//Example 3.12
clc
disp("Step 1: Identify topology")
disp("  The feebdack is given from emitter of Q2 to the base of Q2. If Io = 0 then feedback current through 5 K register is zero, hence it is current sampling. As feedback signal is mixed in shunt with input, the amplifier is current shunt feedback amplifier.")
disp("")
disp("Step 2 and Step 3: Find input and output ")
disp("  The input circuit of the amplifier without feedback is obtained by opening the output loop at the emitter of Q2(Io = 0). This places R''(5 K) in series with Re from base to emitter of Q1. The output circuit is found by shorting the input node, i.e. making Vi = 0. This places R'' (5 K) in parallel with Re. The resultant equivalent circuit is shown in fig.3.59 ")
disp("")
disp("Step 4: Find open circuit transfer gain.")
disp("  A_I = Io / Is = -Ic/I_b2 * I_b2/I_c1 * I_c1/I_b1 * I_b1/Is")
disp("We know that  -I_c2 / I_b2 = A_i2 = -hfe = -50 and")
disp("  -I_c1 / I_b1 = A_i1 = -hfe = 50")
disp("  I_c1 / I_b1 = 50")
disp("Looking at fig.3.59 we can write,")
disp("  I_b2 / I_c1 = -R_c1 / R_c1+R_i2 ")
ri2=1.5+(51*((5*0.5)/(5.5)))  // in k-ohm
format(8)
disp(ri2,"where  R_i2(in k-ohm) = h_ie + (1+h_fe)*(R_e2||R'') =")
x1=-2/(2+24.6818)
disp(x1,"  I_b2 / I_c1 =")
disp("  I_b1 / Is = R / R+R_i1    where R = Rs||(R''+R_e2) ")
r=((1*5.5)/(1+5.5))*10^3  // in ohm
format(9)
disp(r,"Therefore,  R(in ohm) =")
disp("and  R_i1 = h_ie + (1+h_fe)*R_e1 = 16.8 k-ohm")
x1=846.1538/(846.1538+(16.8*10^3))
format(8)
disp(x1,"Therefore,  I_b1 / Is =")
ai=50*0.07495*50*0.04795
format(7)
disp(ai,"  A_I =")
disp("")
disp("Step 5: Calculate beta")
beta=500/(500+(5*10^3))
disp(beta,"  beta = If / Io = R_e2 / R_e2|R'' =")
disp("")
disp("Step 6: Calculate D, A_If")
d=1+(0.0909*8.9848)
disp(d,"  D = 1 + A_I*beta =")
aif=8.9848/1.8168
disp(aif,"  A_If = A_I / D =")
