clear;
clc;
R=16.64;L=5.87*(10^-3);G=1.28*(10^-6);C=0.0134*(10^-6);bmax=0.1;f2=5500;f1=30;
w=2*%pi*f2;
Z=R+(%i*w*L);
Y=G+(%i*w*C);
P=fix(sqrt(Z*Y)*10^4)/10^4;
a=-f1*((-3*real(P)*real(P)*imag(P))-((imag(P))^3))/24;
a1=round(a*1000)/1000;
v=sqrt(bmax/a1);
l=f1/v;
R1=R*f1/(2*l);
L1=L*f1*10^3/(2*l);
C1=C*f1*10^6/l;
G1=G*f1/l;
Rg=1/G1;
printf("The elements of the artificial line are:\n");
printf(" R/2 = %f ohms\n",fix(R1*100)/100);
printf(" L/2 = %f mH\n",fix(L1*100)/100);
printf(" C = %f microfarads\n",fix(C1*1000)/1000);
printf(" Rg = %f k ohms\n",round((Rg*0.1)/100));
