clear;
clc;
R=10.4;L=3.67*(10^-3);G=0.8*(10^-6);C=0.00835*(10^-6);w=5000;r=7.3;l=246*(10^-3);
s=7.88;
Rc=R+(r/s);
Lc=L+(l/s);
Z=fix((Rc+(%i*w*Lc))*100)/100;
Y=G+(%i*w*C);
Zo=sqrt(Z/Y);
A=real(Zo);
B=imag(Zo);
P=sqrt(Z*Y);
a=real(P);
b=imag(P);
Vp=w/b;
phi=(round(atan(imag(Z),real(Z))*180*10/%pi)/10)-round(atan(imag(Y),real(Y))*180*10/%pi)/10;
printf("(i)Using exact method Zo = %f /_ %f ohms\n",round(abs(Zo)),phi);
printf("\t\t\ta = %f neper/km\n",round(a*10^4)/10^4);
printf("\t\t\tVp = %f * 10^4 km/sec\n",round(Vp*10^-2)/10^2);
Zo1=sqrt(Lc/C);
printf("(ii)Using approximate methos Zo = %f ohms\n",round(Zo1));
al=((Rc/2)*sqrt(C/Lc))+((G/2)*sqrt(Lc/C));
printf("\t\t\ta = %f neper/km\n",round(al*10^5)/10^5);
b1=w*(sqrt(Lc*C));
Vp1=1/(sqrt(Lc*C));
printf("\t\t\tVp = %f * 10^4 km/sec",round(Vp1*10^-2)/10^2);
