clear;
clc;
R=10.4;L=0.0036;C=0.0083*(10^-6);G=0;f1=1420;f2=1860;
Favg=(f1+f2)/2;
w=2*%pi*Favg;
Z=R+(%i*w*L);
Y=G+(%i*w*C);
P=sqrt(Z*Y);
a=real(P);
b=imag(P);
v=w/b;
d=v/(2*(f2-f1));
printf("-Approximate distance = %f km\n",round(d));
w1=2*%pi*f1;
Z1=R+(%i*w1*L);
Y1=G+(%i*w1*C);
P1=sqrt(Z1*Y1);
a1=real(P1);
b1=imag(P1);
v1=w1/b1;
w2=2*%pi*f2;
Z2=R+(%i*w2*L);
Y2=G+(%i*w2*C);
P2=sqrt(Z2*Y2);
a2=real(P2);
b2=imag(P2);
v2=w2/b2;
D=(v1*v2)/(2*((v1*f2)-(v2*f1)));
printf("-Exact distance = %f km",round(D*10)/10);
