// Electric Machinery and Transformers
// Irving L kosow 
// Prentice Hall of India
// 2nd editiom

// Chapter 7: PARALLEL OPERATION
// Example 7-9

clear; clc; close; // Clear the work space and console.

// Given data
E_2_mag = 230 ; // Magnitude of voltage generated by alternator 2 in volt
E_1_mag = 230 ; // Magnitude of voltage generated by alternator 1 in volt

theta_2 = 180 ; // Phase angle of generated voltage by alternator 2 in degrees
theta_1 = 20 ; // Phase angle of generated voltage by alternator 1 in degrees

R_a1 = 0.2 ; // armature resistance of alternator 1 in ohm
R_a2 = 0.2 ; // armature resistance of alternator 2 in ohm

// writing given voltage in exponential form as follows
// %pi/180 for degrees to radians conversion
E_2 = E_2_mag * expm(%i * theta_2*(%pi/180) ); // voltage generated by alternator 2 in volt
E_1 = E_1_mag * expm(%i * theta_1*(%pi/180) ); // voltage generated by alternator 1 in volt

// writing given impedance(in ohm)in exponential form as follows
Z_1 = 2.01 * expm(%i * 84.3*(%pi/180) ); // %pi/180 for degrees to radians conversion
Z_2 = Z_1 ;
Z_1_a = atan(imag(Z_1) /real(Z_1))*180/%pi;//Z_1_a=phase angle of Z_1 in degrees

// Calculations
E_r = E_2 + E_1 ; // Total voltage generated by Alternator 1 and 2 in volt
E_r_m = abs(E_r);//E_r_m=magnitude of E_r in volt
E_r_a = atan(imag(E_r) /real(E_r))*180/%pi;//E_r_a=phase angle of E_r in degrees

// case a
I_s = E_r / (Z_1 + Z_2); // Synchronozing current in A
I_s_m = abs(I_s);//I_s_m=magnitude of I_s in A
I_s_a = atan(imag(I_s) /real(I_s))*180/%pi;//I_s_a=phase angle of I_s in degrees

// case b
E_gp1 = E_1_mag;
P_1 = E_gp1 * I_s_m * cosd(I_s_a - theta_1); // Synchronozing power developed by alternator 1 in W

// case c
E_gp2 = E_2_mag;
P_2 = E_gp2 * I_s_m * cosd(I_s_a - theta_2); // Synchronozing power developed by alternator 2 in W

// case d
// but consider +ve vlaue for P_2 for finding losses, so
P2 = abs(P_2);
losses = P_1 - P2 ; // Losses in the armature in W

// E_r_a yields -80 degrees which is equivalent to 100 degrees, so
theta = 100 - I_s_a ; // Phase difference between E_r and I_a in degrees

check = E_r_m * I_s_m * cosd(theta); // Verifying losses by Eq.7-7
R_aT = R_a1 + R_a2 ; // total armature resistance of alternator 1 and 2 in ohm
double_check = (I_s_m)^2 * (R_aT); // Verifying losses by Eq.7-7

// Display the results
disp("Example 7-9 Solution : ");
printf(" \n a: I_s = ");disp(I_s);
printf(" \n    I_s = %.2f <%.2f A \n ",I_s_m, I_s_a );

printf(" \n b: P_1 = %.f W (power delivered to bus)",P_1);
printf(" \n    Slight variation in P_1 is due slight variations in ")
printf(" \n    magnitude of I_s,& angle btw (E_gp1,I_s)\n")
printf(" \n    P_2 = %.f W (power received from bus)\n",P_2);

printf(" \n c: Losses: P_1 - P_2 = %d",losses);
printf(" \n    Check: E_a*I_s*cos(theta) = %d W ",check );
printf(" \n    Double check : (I_s)^2*(R_a1+R_a2) = %d W ",double_check );
