// Electric Machinery and Transformers
// Irving L kosow 
// Prentice Hall of India
// 2nd editiom

// Chapter 7: PARALLEL OPERATION
// Example 7-1

clear; clc; close; // Clear the work space and console.

// Given data
R_sh = 120 ; // Shunt field resistance in ohm
R_a = 0.1 ; // Armature resistance in ohm
V_L = 120 ; // Line voltage in volt
E_g1 = 125 ; // Generated voltage by dynamo A
E_g2 = 120 ; // Generated voltage by dynamo B
E_g3 = 114 ; // Generated voltage by dynamo C

// Calculations
// case a
// 1:
I_gA = ( E_g1 - V_L ) / R_a ; // Current in the generating source A ( in  A)
I_f = V_L / R_sh ; // Shunt field current in A
I_a1 = I_gA + I_f ; // Armature current in A for generator A
I_L1 = I_gA ; // Current delivered by dynamo A to the bus in A

// 2:
I_gB =  ( E_g2 - V_L ) / R_a ; // Current in the generating source B ( in  A)
I_a2 = I_gB + I_f ; // Armature current in A for generator B
I_L2 = I_gB ; // Current delivered by dynamo B to the bus in A

// 3:
I_gC =  ( V_L - E_g3 ) / R_a ; // Current in the generating source C ( in  A)
I_a3 = I_gC ; // Armature current in A for generator C
I_L3 = I_gC + I_f ; // Current delivered by dynamo C to the bus in A

// case b
// 1:
P_LA = V_L * I_L1 ; // Power delivered to the bus by dynamo A in W
P_gA = E_g1 * I_a1 ; // Power generated by dynamo A

// 2:
P_LB = V_L * I_L2 ; // Power delivered to the bus by dynamo B in W
P_gB = E_g2 * I_a2 ; // Power generated by dynamo B

// 3:
P_LC = V_L * I_L3 ; // Power delivered to the bus by dynamo C in W
P_gC = E_g3 * I_a3 ; // Power generated by dynamo C

// Display the results
disp("Example 7-1 Solution : ");
printf(" \n a: 1. I_gA = %d A \t I_f = %d A ", I_gA,I_f );
printf(" \n       Thus,dynamo A delivers %d A to the bus and has an armature", I_gA);
printf(" \n       current of %d A + %d A = %d \n", I_gA,I_f,I_a1 );

printf(" \n    2. I_gB = %d A ", I_gB);
printf(" \n       Thus, dynamo B is floating and has as armature & field current of %d A \n",I_f);

printf(" \n    3. I_gC = %d A ",I_gC);
printf(" \n       Dynamo C receives %d A from the bus & has an armature current of %d A\n",I_L3,I_a3);

printf(" \n b: 1. Power delivered to the bus by dynamo A is : ");
printf(" \n       P_LA = %d W ",P_LA);
printf(" \n       Power generated by dynamo A is \n       P_gA = %d W \n",P_gA);
 
printf(" \n    2. Since dynamo B neither delivers power to nor receives power from the bus, ");
printf(" \n       P_B = %d W ",P_LB);
printf(" \n       Power generated by dynamo B,to excite its field, is");
printf(" \n       P_gB = %d W \n ", P_gB); 

printf(" \n    3. Power delivered by the bus to dynamo C is ");
printf(" \n       P_LC = %d W ", P_LC);
printf(" \n       while the internal power delivered in the direction of rotation");
printf(" \n       of its prime mover to aid rotation is \n       P_gC = %d W", P_gC );
