// Electric Machinery and Transformers
// Irving L kosow 
// Prentice Hall of India
// 2nd editiom

// Chapter 1: Electromechanical Fundamentals
// Example 1-10

clear; clc; close; // Clear the work space and console.

// Given data
no_of_coils = 40;
N = 20; // no of turns in each coil
omega = 200; // angular velocity of armature in rad/s
phi = 5 * 10 ^ -3; // flux per pole
a = 4; // No. of parallel paths
P = 4; // No. of poles

// Calculations
Z = no_of_coils * 2 * N; // No. of conductors

E_g = ( phi * Z *  omega * P ) / ( 2 * %pi * a ); // Voltage generated by the 
// armature between brushes

// Display the results
disp("Example 1-10 Solution : ");
printf("\n Z = % d conductors ", Z);
printf("\n Eg = % .2f V between the brushes ", E_g);
