// Electric Machinery and Transformers
// Irving L kosow 
// Prentice Hall of India
// 2nd editiom

// Chapter 8: AC DYNAMO TORQUE RELATIONS - SYNCHRONOUS MOTORS
// Example 8-4

clear; clc; close; // Clear the work space and console.

// Given data
// Y-connected synchronous dynamo
P = 2 ; // No. of poles
hp = 1000 ; // power rating of the synchronous motor in hp
V_L = 6000 ; // Line voltage in volt
f = 60 ; // Frequency in Hz
R_a = 0.52 ; // Effective armature resistance in ohm
X_s = 4.2 ; // Synchronous reactance in ohm
P_t = 811 ; // Input power in kW
PF = 0.8 ; // Power factor leading

// Calculations
V_p = V_L / sqrt(3); // Phase voltage in volt

// case a
cos_theta = PF ; // Power factor leading
I_L = (P_t*1000) / ( sqrt(3) * V_L * cos_theta); // Line armature current in A
I_ap = I_L ; // Phase armature current in A

// case b
Z_p = R_a + %i * X_s ; // Impedance per phase in ohm
Z_p_m = abs(Z_p);//Z_p_m=magnitude of Z_p in ohm
Z_p_a = atan(imag(Z_p) /real(Z_p))*180/%pi;//Z_p_a=phase angle of Z_p in degrees

// case c
Ia_Zp = I_L * Z_p_m ; 
E_r = Ia_Zp ; 

// case d
theta = acosd(0.8); // Power factor angle in degrees

// case e
funcprot(0); // Use  to avoid this message "Warning : redefining function: beta"                    . 
beta = Z_p_a ; // 
deba = beta + theta // Difference angle at 0.8 leading PF in degrees

// case f
//  Generated voltage/phase in volt 
E_gp_f = sqrt( (E_r)^2 + (V_p)^2 - 2*E_r*V_p*cosd(deba) );

// case g
//  Generated voltage/phase in volt 
E_gp_g = ( V_p + Ia_Zp * cosd(180-deba) ) + %i * ( Ia_Zp * sind(180-deba) ); 
E_gp_g_m = abs(E_gp_g);//E_gp_g_m=magnitude of E_gp_g in volt
E_gp_g_a = atan(imag(E_gp_g) /real(E_gp_g))*180/%pi;//E_gp_g_a=phase angle of E_gp_g in degrees

// case h
IaZp = Ia_Zp * expm(%i * Z_p_a * (%pi/180) ); // voltage generated by alternator 1 in volt
IaZp_m = abs(IaZp);//IaZp_m=magnitude of IaZp in A
IaZp_a = atan(imag(IaZp) /real(IaZp))*180/%pi;//IaZp_a=phase angle of IaZp in degrees
IaRa = IaZp_m*cosd(IaZp_a); // Real part of IaZp
IaXs = IaZp_m*sind(IaZp_a); // Imaginery part of IaZp

cos_theta = PF ; //
sin_theta = sqrt( 1 - (cos_theta)^2 );
//  Generated voltage/phase in volt 
E_gp_h = ( V_p * cos_theta - IaRa ) + %i * ( V_p * sin_theta + IaXs);
E_gp_h_m = abs(E_gp_h);//E_gp_h_m=magnitude of E_gp_h in volt
E_gp_h_a = atan(imag(E_gp_h) /real(E_gp_h))*180/%pi;//E_gp_h_a=phase angle of E_gp_h in degrees

// Display the results
disp("Example 8-4 Solution : ");
printf(" \n a: I_L = %.2f \n    I_ap = %.2f A \n", I_L, I_ap );

printf(" \n b: Z_p in ohm = ");disp(Z_p);
printf(" \n    Z_p = %.3f <%.2f ohm \n ", Z_p_m , Z_p_a );

printf(" \n c: IaZp = %.1f V \n    E_r = %.1f V \n ",Ia_Zp , E_r );

printf(" \n d: Power factor angle,\n    theta = %.2f degrees leading \n ", theta );

printf(" \n e: Difference angle,\n    deba = %.2f degrees \n ", deba );

printf(" \n f: E_gp = %.f V \n ", E_gp_f );
 
printf(" \n g: E_gp in V = ");disp(E_gp_g );
printf(" \n    E_gp = %d <%.2f V \n",E_gp_g_m , E_gp_g_a );

printf(" \n h: E_gp in V = ");disp(E_gp_h);
printf(" \n    E_gp = %.f <%.2f V",E_gp_h_m, E_gp_h_a );
