// Electric Machinery and Transformers
// Irving L kosow 
// Prentice Hall of India
// 2nd editiom

// Chapter 7: PARALLEL OPERATION
// Example 7-3

clear; clc; close; // Clear the work space and console.

// Given data
R_a = 0.1 ; // Armature resistance in ohm of 3 shunt generators
R_a1 =R_a ; 
R_a2 =R_a ; 
R_a3 =R_a ; 
R_L = 2 ; // Load resistance in ohm
E_g1 = 127 ; // Voltage generated by generator 1 in volt
E_g2 = 120 ; // Voltage generated by generator 2 in volt
E_g3 = 119 ; // Voltage generated by generator 3 in volt
// Neglect field currents

// Calculations
// case a
// Terminal bus voltage in volt
V_L = ( (127/0.1) + (120/0.1) + (119/0.1) ) / ( (1/0.1) + (1/0.1) + (1/0.1) + 0.5);

// case b
I_L1 = (E_g1 - V_L)/R_a1 ; // Current delivered by generator 1 in A
I_L2 = (E_g2 - V_L)/R_a2 ; // Current delivered by generator 2 in A
I_L3 = (E_g3 - V_L)/R_a3 ; // Current delivered by generator 3 in A
I_L_2ohm = V_L / R_L ; // Current delivered by 2 ohm load in A

// case c
I_a1 = I_L1 ; // Armature current in A for generator 1
I_a2 = I_L2 ; // Armature current in A for generator 2
I_a3 = I_L3 ; // Armature current in A for generator 3

P_g1 = E_g1 * I_a1 ; // Power generated by generator 1 in W
P_g2 = E_g2 * I_a2 ; // Power generated by generator 2 in W
P_g3 = E_g3 * I_a3 ; // Power generated by generator 3 in W

// case d
P_L1 = V_L * I_L1 ; // Power delivered to or received from generator 1 in W
P_L2 = V_L * I_L2 ; // Power delivered to or received from generator 2 in W
P_L3 = V_L * I_L3 ; // Power delivered to or received from generator 3 in W
P_L = V_L * -I_L_2ohm ; // Power delivered to or received 2 ohm load in W

// Display the results
disp("Example 7-3 Solution : ");
printf(" \n a: Converting each voltage source to a current source and applying");
printf(" \n    Millman`s theorem yields ")
printf(" \n    V_L = %d V \n ", V_L );

printf(" \n b: I_L1 = %d A (to bus)", I_L1 );
printf(" \n    I_L2 = %d A ", I_L2 );
printf(" \n    I_L3 = %d A (from bus)", I_L3 );
printf(" \n    I_L_2ohm = -%d A (from bus) \n", I_L_2ohm );

printf(" \n c: P_g1 = %d W ",P_g1 );
printf(" \n    P_g2 = %d W (floating)",P_g2 );
printf(" \n    P_g3 = %d W \n",P_g3 );

printf(" \n d: P_L1 = %d W ", P_L1);
printf(" \n    P_L2 = %d W ", P_L2 );
printf(" \n    P_L3 = %d W ", P_L3 );
printf(" \n    P_L = %d W ", P_L );
