// Fluid & Mesh Properties

// Prompt for default or custom mesh values
choice = input("Do you want to use default values for mesh? (Y/N): ", "string");
if choice == "Y" | choice == "y" then
    H = 0.01;  L = 10 * H;  Nx = 9;  Ny = 4;  dz = 0.001;
else
    H = input("Enter channel height in m: ");
    L = input("Enter channel length in m: ");
    Nx = input("Enter number of cells in x direction: ");
    Ny = input("Enter number of cells in y direction: ");
    dz = input("Enter width in z direction (in m): ");
end

// Display selected parameters
disp("Using the following parameters:");
disp("Channel Height (H): " + string(H) + " m");
disp("Channel Length (L): " + string(L) + " m");
disp("Cells in x direction (Nx): " + string(Nx));
disp("Cells in y direction (Ny): " + string(Ny));
disp("Width in z direction (dz): " + string(dz) + " m");

// Global variables
global Fw Fe Fn Fs DF aW aE aS aN aP bP dU dV;

// Geometry and Grid
dx = L / Nx;  dy = H / Ny;
x  = (dx/2 : dx : L-dx/2)';
xu = (0 : dx : L)';
y  = (dy/2 : dy : H-dy/2)';
yv = (0 : dy : H)';
iF = 2 : Nx;  Ju = 2 : Ny+1;  Iv = 2 : Nx+1;  jF = 2 : Ny;
Ip = 2 : Nx+1;  Jp = 2 : Ny+1;

// Prompt for fluid properties
choice = input("Do you want to use default fluid properties? (Y/N): ", "string");
if choice == "Y" | choice == "y" then
    rho = 1.2;  mu = 1.8e-5;  kt = 0.025;  cp = 1006;  Re = 500;
else
    rho = input("Enter fluid density (kg/m^3): ");
    mu  = input("Enter dynamic viscosity (N-s/m^2): ");
    kt  = input("Enter thermal conductivity (W/m-K): ");
    cp  = input("Enter specific heat (J/kg-K): ");
    Re  = input("Enter Reynolds Number (within Laminar flow limits): ");
end

// Derived properties
nu = mu / rho;
alpha_thermal = kt / (rho * cp);
Pr = nu / alpha_thermal;
U = Re * nu / (2 * H);
Ti = 300;  Tw = 300;  qw = 100;
BC_N = 1;  BC_S = 1;

// Prompt for relaxation parameters
choice_relax = input("Do you want to use default relaxation parameters? (Y/N): ", "string");
if choice_relax == "Y" | choice_relax == "y" then
    alphaU = 0.3;  alphaP = 0.2;  NmaxSIM = 1e4;  NmaxGSI = 10;  tol = 1e-5;  div = 1e1;
else
    alphaU = input("Enter velocity relaxation factor: ");
    alphaP = input("Enter pressure relaxation factor: ");
    NmaxSIM = input("Enter max SIMPLE iterations: ");
    NmaxGSI = input("Enter max Gauss-Seidel iterations: ");
    tol = input("Enter convergence tolerance: ");
    div = input("Enter divergence threshold: ");
end

//------------------------------------------------------------------
// Define Function to Plot the Mesh
//------------------------------------------------------------------
function plotmesh(L, H, Nx, Ny)
    dx = L / Nx;
    dy = H / Ny;
    clf();
    a = gca();
    a.data_bounds = [0, 0; L, H];
    a.isoview = "on";
    a.auto_clear = "off";
    
    for i = 0:Nx
        x_val = i * dx;
        plot([x_val, x_val], [0, H], "b-");
    end
    
    for j = 0:Ny
        y_val = j * dy;
        plot([0, L], [y_val, y_val], "b-");
    end
    
    xlabel("x (m)"); ylabel("y (m)"); title("Computational Mesh");
    a.auto_clear = "on";
    drawnow();
endfunction

// Plot the mesh
plotmesh(L, H, Nx, Ny);

disp("Mesh visualization completed.");
