// Final Output: Export Data to CSV Files

disp("Simulation completed. Exporting data to CSV files...");

// Prompt user to select the folder where output files (e.g., CSVs) will be saved
savePath = uigetdir('Select a folder to save the output files (e.g., CSVs):');

if savePath <> "" then
    disp("Output files will be saved to: " + savePath);
else
    error("No folder selected. Please run the script again and choose a valid output directory.");
end


// Create directory if it doesn't exist
if ~isdir(savePath) then
    mkdir(savePath);
end

// We are transposing the data to align it correctly with the computational grid, ensuring that each value corresponds to the appropriate cell location. 
//This helps in accurate visualization and interpretation of flow variables within the 4×9 mesh.

// Save all results using write function with transposed data
write(savePath + "residuals.csv", [ures' vres' pres']);
write(savePath + "pressure.csv", p');
write(savePath + "velocity_u.csv", u');
write(savePath + "velocity_v.csv", v');
write(savePath + "temperature.csv", T');

disp("CSV files have been exported to " + savePath);

disp("U-Velocity Data");
disp(u');  // Transpose of u

disp("V-Velocity Data");
disp(v');  // Transpose of v

disp("Pressure Data");
disp(p');  // Transpose of p

disp("Temperature Data");
disp(T');  // Transpose of T
