//------------------------------------------------------------------
// Initialize Fields
//------------------------------------------------------------------

// u: (Nx+1) x (Ny+2) because u-velocity is stored at faces in y-direction.
u = zeros(Nx+1, Ny+2);
v = zeros(Nx+2, Ny+1);
uStar  = zeros(Nx+1, Ny+2);
vStar  = zeros(Nx+2, Ny+1);
uPrime = zeros(Nx+1, Ny+2);
vPrime = zeros(Nx+2, Ny+1);
dU     = zeros(Nx+1, Ny+2);
dV     = zeros(Nx+2, Ny+1);

// Temperature and Pressure fields: (Nx+2) x (Ny+2)
T      = zeros(Nx+2, Ny+2);
p      = zeros(Nx+2, Ny+2);
pStar  = zeros(Nx+2, Ny+2);
pPrime = zeros(Nx+2, Ny+2);

// Global Coefficient Matrices (size based on internal nodes)
Fw = zeros(Nx+1, Ny+1);
Fe = zeros(Nx+1, Ny+1);
Fn = zeros(Nx+1, Ny+1);
Fs = zeros(Nx+1, Ny+1);
DF = zeros(Nx+1, Ny+1);
aW = zeros(Nx+1, Ny+1);
aE = zeros(Nx+1, Ny+1);
aS = zeros(Nx+1, Ny+1);
aN = zeros(Nx+1, Ny+1);
aP = zeros(Nx+1, Ny+1);
bP = zeros(Nx+1, Ny+1);

// Residual Histories
ures = zeros(NmaxSIM, 1);
vres = zeros(NmaxSIM, 1);
pres = zeros(NmaxSIM, 1);

//------------------------------------------------------------------
// Set Inlet Velocity (Uniform Inlet)
u(:, Ju) = U;

// Initialize Pressure Field with a Linear Drop (Fully Developed Flow)
p1 = 12 * mu * U * L / ((2 * H)^2);
linP = linspace(p1, 0, Nx);
for i = 1:Nx
    for j = 1:Ny
        // p is stored on a (Nx+2) x (Ny+2) grid; interior nodes offset by 1.
        p(i+1, j+1) = linP(i);
    end
end

// Initialize Temperature Field: Inlet and Wall Temperatures
T(:, Jp)   = Ti;
T(:, 1)    = Tw;
T(:, Ny+2) = Tw;

// Diffusion Coefficients for Momentum Equations (constant)
Dx = (mu/dx) * dy * dz;
Dy = (mu/dy) * dx * dz;

//------------------------------------------------------------------
// Prompt for Temperature Equation Solution
//------------------------------------------------------------------
solve_temp = input("Do you want to solve the temperature equation? (Y/N): ", "string");





