//--- Monte Carlo Estimation of Pi in Scilab ---
printf("\n----- Monte Carlo Estimation of Pi in Scilab -----");
// Prompt the user for the number of random points to generate
printf("\nThe range for the following is preferably [1000-150000]\nFor large input, wait for a while.\n\n");
N = input("Enter the total number of points: ");

// Function to estimate Pi and plot the simulation
function pi_est = estimatePi(N)
    
    // Initialize counter and arrays for plotting
    insideCircle = 0;
    xInside = []; yInside = [];  // points inside the quarter circle
    xOutside = []; yOutside = [];  // points outside the quarter circle

    // Generate N random points in the unit square [0,1]x[0,1]
    for i = 1:N
        x = rand();
        y = rand();
        
        // Check if the point is inside the quarter circle (x^2 + y^2 <= 1)
        if (x^2 + y^2 <= 1) then
            insideCircle = insideCircle + 1;
            xInside = [xInside, x];
            yInside = [yInside, y];
        else
            xOutside = [xOutside, x];
            yOutside = [yOutside, y];
        end
    end
    // Estimate Pi: for a quarter circle, (inside/N) approximates (pi/4)
    pi_est = 4 * (insideCircle / N);
    
    function f = myfunction(x)
    f = sqrt(1 - x .^ 2)
    endfunction
    xdata = linspace(0, 1, 100);
    ydata = myfunction(xdata);
    plot(xdata, ydata);

    // Plot points inside the quarter circle in green circles
    plot(xInside, yInside, "og");
    // Points outside the circle in red
    plot(xOutside, yOutside, "ro"); 
    // Label the axes and add a title
    xlabel("X");
    ylabel("Y");
    xtitle("Monte Carlo Estimation of Pi", "X", "Y");

    // Set the plot limits to exactly show the unit square
    a = gca();
    a.data_bounds = [0, 0; 1, 1];
endfunction

// Call the function and display the estimated value of Pi
pi_estimated = estimatePi(N);

printf("Estimated Pi: %f\n", pi_estimated );

printf("\n----- Sobol Sequence Design -----");
// Sobol Sequence Design
// Function to generate Sobol sequence manually
function sobol_samples=generate_sobol(n, dim)
    sobol_samples = zeros(n, dim); // Initialize the array to store Sobol samples
    
    // Simple Sobol sequence generation method
    for i = 1:n
        for j = 1:dim
        sobol_samples(i, j) = (i + j - 1) / n; // Simple division to generate uniform points
        end
    end
endfunction

// Number of Sobol points
points = input("Enter the sample size: "); // Number of points
dim = 2; // Dimensionality (2D)

// Generate Sobol samples
sampling = generate_sobol(points, dim);

// Create a new figure window
scf();

// Plot Sobol sample points using blue circles
plot(sampling(:, 1), sampling(:, 2), "bo");
xgrid();
xtitle("Sobol Design", "X1", "X2");

//Stuff like Quadrature Design
printf("\n----- Quadrature Design -----\n");
// Number of samples
number_of_points = input("Enter the number of points for quadrature design: ");;

// Define the list of sampling methods
names = [
"Quadrature";
"Petras";
"Smolyak_Gauss";
"Smolyak_Fejer";
"Smolyak_Trapeze";
"Smolyak_Clenshaw_Curtis"
];

// Generate random samples
sampling = rand(number_of_points, 2); // Generates a 10x2 matrix of random numbers

// Plot the samples
scf(); // Create a new figure
plot(sampling(:, 1), sampling(:, 2), "bo");
xtitle("Quadrature Design", "X1", "X2");

// Loop over maxdegree values from 1 to 9
for maxdegree = 1:9
    mprintf("\nmaxdegree=%d\n", maxdegree);
    
    // Loop over each sampling method
    for i = 1:size(names, "r")
        method = names(i);
    
        // Example: Generate random samples as a placeholder
        // Replacable: sampling logic based on the method
          number_of_points = 10 * maxdegree;
          sampling = rand(number_of_points, 2);
        
        // Print the method name and number of points
        mprintf(" %s, number of points=%d \n", method, number_of_points);
    end
end

// Add gridlines ("cuts")
n = 10000;
cut = linspace(0, 1, n); // Generate n equally spaced points between 0 and 1

// Generate random points in the unit square
x_random = rand(1, number_of_points);
y_random = rand(1, number_of_points);

//Application of quadrature design
// Define function to integrate (example: f(x) = x^2)
deff('y=f(x)', 'y=x.^2');

// Compute integral using Quadrature method
[result, err] = intg(0, 1, f);

// Plot the Quadrature Design points
scf();
plot2d(x_random, y_random, style=-9, leg="Quadrature Points"); 
xgrid();
xtitle("Applied Quadrature Design Sampling", "X-axis", "Y-axis");
