// UAV-aided Wireless Communication Coverage Probability Simulation

clc;
clear;
close;

// Parameters
num_users = 1000; // Number of users
Coverage_area = [500 1000 1500]; // Size of the area (1000m x 1000m)
transmit_power_dB = 10; // Transmit power in dB
transmit_power = 10^(transmit_power_dB / 10);
noise_power = 10e-10; // Noise power in Watts
f = 2e9; // Frequency in Hz (2 GHz)
threshold_snr_dB = 5; // SNR threshold in dB
threshold_snr = 10^(threshold_snr_dB / 10); // Convert dB to linear scale
eta_los = 0.1;
eta_Nlos = 21;      // Environmental Parameters
a1 = 5.0188;
b1 = 0.3511;

// Speed of light and wavelength
c = 3e8; // Speed of light in m/s
wavelength = c / f; // Wavelength in meters



// UAV altitude range for simulation
uav_altitudes = 1:10:1000; // Altitudes from 10m to 500m
coverage_probabilities = zeros(1, length(uav_altitudes)); // Initialize array for coverage probabilities

// Loop through each UAV altitude and calculate coverage probability
for i = 1:3
// Generate user positions (randomly distributed)
    x_users = rand(1, num_users) *  Coverage_area(i) - Coverage_area(i) / 2; // x-coordinates in range [-500, 500]
    y_users = rand(1, num_users) *  Coverage_area(i) - Coverage_area(i) / 2; // y-coordinates in range [-500, 500]
for j = 1:length(uav_altitudes)
    uav_altitude = uav_altitudes(j); // Current altitude
    // Calculate distances from UAV to users
    distances = sqrt(x_users.^2 + y_users.^2 + uav_altitude^2); // 3D distance
    // Path loss
    A = eta_los - eta_Nlos;
    B = 20*log10(distances) + 20*log10((4 * %pi * f) / c) + eta_Nlos;
    theta = (180 / %pi) * atan(uav_altitude ./ sqrt(x_users.^2 + y_users.^2));
    P_L1 = A ./ (1 + (a1 * exp(-b1 .* (theta - a1))));
    P_L = P_L1 + B;
    PL = 10.^(P_L / 10); // Convert path loss to linear scale
    // Calculate SNR for each user
    snr = transmit_power ./ (PL * noise_power);
    // Coverage probability: Count users with SNR >= threshold
    coverage_users = sum(snr >= threshold_snr);
    coverage_probabilities(j) = coverage_users / num_users;
end
 colors = ["b", "r", "g"]; // Blue, Red, Green, Magenta
    plot(uav_altitudes, coverage_probabilities*100, colors(i) , "LineWidth", 2); // Plot with specified color and markers
end

// Plot coverage probability vs. UAV altitude
legends = ["Area=500", "Area=1000", "Area=1500"];
legend(legends, "Location", "northwest");
xlabel("UAV Altitude (m)", "FontSize", 3);
ylabel("Coverage Probability (%)", "FontSize", 3);
title("Coverage Probability vs. UAV Altitude", "FontSize", 3);
xgrid();
