//This function generates the noise similar to the noise generated by the cloud.
function [out] = cloud_noise(im,D,n)
//im = image passed in as parameter 
//D = cutoff frequency 
//n = order of the filter
h = size(im,1);// height of the image
w = size(im,2);// width of the image 
// Here we are making the filter according to the width of the fiter 
[x ,y] = meshgrid(-floor(w/2):floor((w-1)/2),-floor(h/2):floor((h-1)/2));
out  = 1./(1+(D./(x.^2+y.^2).^0.5).*(2*n));//butter worth filter equation. 
out = 1-out;
figure;
imshow(out);

end

