
[chess2] = imread('chessboardgrayscale.png');// Importing the images.
chess=chess2;


chess = im2double(chess);//Converting image into Double for further calculation

[h w]=size(chess);//h-->ROWS,w-->COLUMNS

// noise generated
if count==0 then
t =(1-0.02)*rand(h,w)+ 0.02;//version 1 noise (random noise varying in between 0.02~1)
imshow((t));
end
if count == 1 then
    X = cloud_noise(chess,10,1);//version 2 moise similar to clouds
        t = X;//Copying the varaiable for maintaining the consistency in the code.   
    end


//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// PARAMETERS OF THE MODEL --> s=alpha*L*r(x,y)*t(x,y) + L[1-t(x,y)]

//MODEL DESCRIPTION
/*s=alpha*L*r(x,y)*t(x,y) + L[1-t(x,y)]
    s - L = alpha*L*r(x,y)*t(x,y) - L*t(x,y);
    
    L - s = [L - alpha*L*r(x,y)]t(x,y)
    
    Now taking the log both sides 
    
    log(L-s) = log(t(x,y) + log(L - alpha*L*r(x,y));
    */
    
//alpha = 1; This parameter is shifted to the Case_study2.sce file for avoiding problem of DOUBLE COUNTING--> Problem where a same variable would be required to 
//           change in many file whereas it should remain same for all the files
//alpha = 1;
 //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 /*
 Class  Approximate Transmission forvalue of alpha  
 end
Fu11    Cloud O. 1
Most    Cloud 0.3
Ha1f    Cloud 0.5
Small   Cloud 0.75
Water   (very thin cloud) 1.0
Ground  (very thin cloud) 1.0
*/

L = max(chess(:));// brightest pixel 
r = chess; // r= desired image 


//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// computation of the model for different channels
s = (((alpha*L).*r).*t) + L.*(1-t);// "s" is the corrupted image recieved by the satellite or simply the scanner image as mentioned in the documentation.
figure;
imshow(s);
title('INPUT')

raw_input = log(L-s +0.01);//here 0.01 is used since due to model used it may happen L=s and in that case "Log(L-s)-->(negative infinity)".Since Log(0)= -(infinity)


// FFT Transform of raw_input
raw_input_fft = fft2(raw_input);


// Ideal low pass filter
Hj=ideal_lpf(chess,1500);
    //Inverse FFT 
    hj=ifft2(bool2s(Hj));
        // Kaiser Window
        kaiser_coefficient = 0;    //kaiser_coefficient 	window shape
                                  //        0           	Rectangular shape
                                 //         5           	Similar to the Hamming window
                                //          6           	Similar to the Hanning window
                               //           8.6         	Similar to the Blackman window
        w= window2(h,w,kaiser_coefficient);
         //multiplication of the ideal low pass filter spatialresponse and window function or in (time domain in vague sense)  
       h_spatial=hj.*w;
    //Fourier transrom for getting the frequency response of the system.
    H_uv=fft2(h_spatial);
   
//Output steps 
    //stage 1
    //frequency domain multiplication of raw_input_fft with H_uv to produce 
    //output in frquency domain.
    Output_in_frequency_domain = raw_input_fft.*H_uv;
    
    //stage 2
    // IFFT of the previous frequncy domain output
    Output_in_time_domain = ifft2(Output_in_frequency_domain);
    
    //stage 3 removing exponent and obtaining the noise calculated usin the model 
    t_new = exp(Output_in_time_domain);
    //ifftshow(t_new);
    //title('t_new');
    
    
    //NOTE:- Here the noise obtained is plugged in the inverse equation of the model to get output image
    output_image = ((L/alpha) - ((L-s)./(alpha*(t_new))));
    
    //shows the output
    ifftshow((output_image));
    title("OUTPUT");
    
    


   



