//This function is used for making the Ideal Low Pass Flter. 
function [out] = ideal_lpf(im,D)
    //im = image passed in as parameter to the function 
    //D = cutoff of the LPF filter.
    h = size(im,1);// height of the image
    w = size(im,2);// width of the image 
    // Here we are making the filter according to the width and height of the fiter 
    [x ,y] = meshgrid(-floor(w/2):floor((w-1)/2),-floor(h/2):floor((h-1)/2));
    z = sqrt(x.^2+y.^2);
    out=z<=D;//D is the  cutoff frequency;
    //figure();
    //imshow(out);
    
endfunction
