clc;


//change the file path in order to play the audio file 

Fmin=20;//Minimum frequency in human audible range;  
Fmax=20e3;// range of frequency audible to human [Fmin Fmax] 
subplot(4,2,1);title("Original Spectrum");xlabel("Frequency");
analyze(OriginalAudio,Fmin,Fmax,Fs,length(OriginalAudio)); // Frequency domain plot of original audio sample.
//analyze() => Used to plot the signal in frequency domain
subplot(4,2,2);title("Original time Signal");xlabel("Time");
plot2d(OriginalAudio(1,:));// Time domain plot of original audio sample.

//-------------------------------------To set the parameters of the filters using built-in GUI tool use "wfir()"-----------------------------------------------------------------------------------

fr=wfir();// used to obtain the fir coefficient using wfir();
//set the value for low pass filter(fiter type=Lowpass ,Sampling frequency=44100,Window type=Triangular,Low cutoff frequency=2205,Filter Order=48) to get the noise removed from background.

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
OriginalAudio = 1.7.*OriginalAudio;//Pre-amplification of the audio signal (done to avoid any attenuation of the signal 1.7 is simply the 4.6dB gain on the equalizer )
playsnd(OriginalAudio,Fs);//Playing Original Track


//Giving description of the filter on the scilab console 
disp("First Filter");
disp("step 1: fiter type=Band Pass ");
disp("step 2 :Sampling frequency=44100");
disp("step 3 :Window type=Triangular,Low cutoff frequency=600 Hz ,Upper cutoff frequency=2000,Filter Order=48");
disp("Original Track is being played");

[fr,wfm,wft]=wfir("bp",481,[0.01360544220 0.0453514739],"tr",[0 0]);; //fr is the time domain filter response 
                                                        //wfm is the frequency domain filter response
                                                        // frequency grid
//fr = 10*fr;//scalar is multiplied to avoid the attenuation in audio signal due the filter response. 
sleep(20,"s");//used to get the noticeable delay. before playing 
exec('Case_study_dependent2.sci', -1);// Next script will automatically load after the audio has finished playing. 
