
//This function plays the original audio file first. Then it reverses the audio file and plays the reversed audio file.
clc;
clear;
MyFile=uigetfile("*.wav"); // prompting the user to select audio file 

[originalaudio fs]=wavread(MyFile);//reading the audio file using wavread function, storing sampling frequency in fs           
playsnd(originalaudio,fs,1);//playing the original audio file
sleep(3,"s");//pausing for three seconds

d=matrix(originalaudio.',1,-1);//converting the matrix of input signal(originalaudio) into a single row vector
e=flipdim(d,2); //flipping the row vector along the 2nd dimension using the flipdim function 
playsnd(e,fs,1); //playing the reversed audio file 

subplot(2,1,1);// to create two graphs(two rows, single column) and plotting first graph 
plot2d(originalaudio(1,:)); // plotting input signal(originalaudio) in time domain using plot2d function 
xlabel("Time");
ylabel("Amplitude");
subplot(2,1,2);// to create two graphs(two rows, single columns) and plotting 2nd graph 

plot2d(e(1,:));//plotting output signal(reversed file) in time domain using plot2d function 
xlabel("Time");
ylabel("Amplitude");
