function s=scale(BB)/*This function is to calculate the scale of the image it calculates the scale in pixels per mm.
 The distances are computed either in pixels or in mm. It is not possible to calculate the distances in mm without knowing the scale
  The scale can either be calculated if a circular object of known diameter is placed in the leftmost part of the image or has to be manually caluculated
  The scale could be manually calculated if the height or width of the image is known in mm and pixels both. The user then has to divide the no of pixels with the size in mm of either the width or the height..*/
    minni=min(BB(1,1:$))
[l,k]=find(BB(1,1:$)==minni)// Finds the left most object
w=BB(3,k);
h=BB(4,k);
tol=abs(w-h)// tol variable to check for circularity of object
disp ("If you wish to know the distances in mm then either the scale must be given in pixels/mm");
disp( "or the leftmost object must be circular and its size in mm must be given");
disp("Else the distance will be computed in pixels");
disp('input scale in the units pixels/mm   ')
    disp('enter 0 if you dont know the scale')
    s=input("");
    if(tol<w*0.05)
        disp("Leftmost object is circular please give the size of the object in mm give 0 if size of object is unknown")
        x=input("");
        if(x~=0)
   s=sqrt(w*h)/x;
   s=s*0.95// Scale taken will always be 5% more than actual as objects bounding boxes will be larger than object
else
    s=0;
end
end
endfunction
