D = CL_path("SHAPES", fullfile(CL_home(), "data")); 
exec(fullfile(D, "shapes_util.sce"));

// Define a  spacecraft
//Satellites vary in size, depending upon their functions and target orbit.

printf('\nRange of the dimensions of satellite body ~ 0.1 m to 7 m\nRange of the dimensions of solar arrays ~ 0.0025 m to 9 m\n')
printf('\n*****Provide the following in meters, all dimensions must be positive*****\n\n')
x = input("Enter the length of the satellite body: ");
y = input("Enter the width of the satellite body: ");
z = input("Enter the height of the satellite body: ");
printf('The size of solar panels is largely decided by the electric power it generates, and size of the satellite body, on which they are to be affixed.\n\n')
xs = input("Enter length of the solar panel: ");
ys = input("Enter width of the solar panel: ");
dim_body = [x; y; z]; // x, y, z (m)
dim_array = [xs; ys];
gap = input("Enter the gap between solar panels and body of the satellite: "); // (m)
A = input('Enter angle (in degrees) in which solar array is tilted about x axis: ')
rot_angle = CL_deg2rad(A); // around x (rad)

obj = make_spacecraft(dim_body, dim_array, gap, rot_angle); 

// plot the spacecraft
scf()
plot_spacecraft(obj); 
xtitle("Spacecraft Model in inertial frame");

// Define the orbit and propagate it 
// inclination = in deg, local time of asc. node = 12 h
printf('\nProvide a suitable month and year for the satellite''s orientation\n\n')
Month = input('The month is [range ~ 1 to 12]: ')
Year = input('The year is: ')

cjd0 = CL_dat_cal2cjd(Year, Month, 14, 0, 0, 0); 

kep0 = [7.e6; 1.e-3; 98 * %pi / 180; 0; 0; 0]; 
kep0(5) = CL_op_locTime(cjd0, "mlh", 12, "ra"); 
T = CL_kp_params("per", kep0(1)); // orbit period 
t = linspace(0, T, 101); 
cjd = cjd0 + t / 86400; 

kep = CL_ex_kepler(cjd0, kep0, cjd); 
[pos, vel] = CL_oe_kep2car(kep); 

// Define the spacecraft frame (inertial frame -> spacecraft frame)
// Xsat: -angular momentum
// Zsat: radial direction (zenith)
Msat = CL_fr_locOrbMat("Wsq", pos, vel); 

// Velocity (relative to rotating Earth) in spacecraft frame 
// vel_ecf_eci: velocity / rotating Earth, coordinates in ECI   
[pos_ecf, vel_ecf] = CL_fr_convert("ECI", "ECF", cjd, pos, vel); 

// velocity of spacecraft / atmosphere (coord. in inertial frame) 
vel_atm = CL_fr_convert("ECF", "ECI", cjd, vel_ecf);

// plot the spacecraft in a specific frame ("AN" frame): 
// X -> ascending node, Z -> north pole
// Note : 2nd argument of plot_object: transformation matrix from this frame to the spacecraft's frame

scf()
plot_spacecraft(obj, Msat(:,:,1) * CL_rot_angles2matrix(3, kep0(5))'); 
xtitle("Spacecraft in the simulated frame at initial epoch");

printf('\nEnter 0 to exit\nFor fixed solar panel analysis, enter 1\nFor rotating solar array, enter 2\n\n')
check = input('Enter a number: ')
while check ~= 0
    if check == 1 then
        // Area over one orbit - fixed solar array.
        // Note : If the velocity / atmosphère was the inertial velocity, the expected area would be : l_body*l_body = 9 m^2
        opts = struct("resol", 200000); 
        area = CL_stela_area(obj, "fix", Msat * vel_atm, opts = opts);
        // Compute average area 
        area_mean = CL_mean(area, meth = "trap"); 
        scf(); 
        plot(t, area); 
        plot(t, area_mean * ones(t), "thickness", 2); 
        xtitle("Area and mean area (m^2)"); 
        CL_g_stdaxes();
        
    elseif check == 2 then
        // Area over one orbit - rotating solar array.
        // Compute the rotation angle, angle between Z axis of solar array and Sun direction (in spacecraft frame) as small as possible. 
        dirsun = CL_eph_sun(cjd); 
        dirsun_sat = Msat * dirsun; 
        k = find(obj.id == "array1");
        cell_axis = obj.z_axis(:,k); 
        rot_axis = obj.x_axis(:,k)
        [qa, rot_angle, Inok] = CL_rot_defRot1Ax(cell_axis, rot_axis, dirsun_sat, 0);
        // compute the rotation structure for the computation of the mean area
        rotdesc_list = list(); 
        rotdesc = struct(); 
        rotdesc.id = "array1"; 
        rotdesc.axis = rot_axis; 
        rotdesc.ang = rot_angle; 
        rotdesc_list($+1) = rotdesc; 
        
        rotdesc = struct(); 
        rotdesc.id = "array2"; 
        rotdesc.axis = rot_axis; 
        rotdesc.ang = rot_angle; 
        rotdesc_list($+1) = rotdesc; 
        
        opts = struct("resol", 200000); 
        area = CL_stela_area(obj, "fixr", Msat * vel_atm, rotdesc_list, opts = opts); 
        
        // compute average area 
        area_mean = CL_mean(area, meth = "trap");
        scf()
        plot(t, area); 
        plot(t, area_mean * ones(t), "thickness", 2); 
        xtitle("Area and mean area (m^2)"); 
        CL_g_stdaxes();
        
    else
        check = input('Please enter a suitable number: ')
    end
    
    check = input('Enter a number [0, 1 or 2]: ')
end

opts = struct("resol", 200000); 
area = CL_stela_area(obj, "fix", Msat * vel_atm, opts = opts);

// Compute average area 
area_mean = CL_mean(area, meth = "trap"); 
 
// Area x density over one orbit
// computation of atmosphere density (average solar activity)
printf('Solar flux intensity throughout the solar system (it decreases on receding the sun):\nLocation                 Average solar flux (W/m2)\nMercury                  8,750\nVenus                    2,857\nEarth                    1,400\nMars                     622\nJupiter                  52\nSaturn                   15\nUranus                   4\nNeptune                  2\nPluto                    1\n\n')
Flux = input('Solar flux [Greater than or equal to 1]: '); 
Ap = 15; 

pos_ecf_ell = CL_co_car2ell(pos_ecf); 

rho = CL_mod_atmMSIS00(cjd, pos_ecf_ell(1,:), pos_ecf_ell(2,:), pos_ecf_ell(3,:), Flux, Flux, Ap, res="dens"); 

// compares mean(density x area) with mean(density) x mean(area)
rho_mean = CL_mean(rho, meth = "trap"); 
rho_area_mean = CL_mean(area .* rho, meth = "trap"); 

UNIT = 1.e-13; 
scf()
plot(t, area .* rho / UNIT, "r"); 
plot(t, rho_area_mean * ones(t) / UNIT, "r", "thickness", 2); 
plot(t, area_mean * rho / UNIT, "b"); 
plot(t, area_mean * rho_mean * ones(t) / UNIT, "b", "thickness", 2); 
xtitle("Area x density (1.e-13 kg/m)"); 
CL_g_legend(gca(), ["var", "var (mean)", "const", "const (mean)"]); 
CL_g_stdaxes();

// Effect of drag on semi major axis 
mass = input('Enter mass of the spacecraft in kilograms: ');
Cx = 2.7;  
M_gauss = CL_op_gauss("kep", kep, "inertial"); 

// acceleration due to drag (variable area)
acc = CL_dMult(-vel_atm, CL_norm(vel_atm) .* rho .* area) * Cx / mass; 

dkepdt = M_gauss * acc; 
smadot = dkepdt(1,:); 
smadot_mean = CL_mean(dkepdt(1,:), meth = "trap");

//Acceleration due to drag (mean area)
acc2 = CL_dMult(-vel_atm, CL_norm(vel_atm) .* rho .* area_mean) * Cx / mass 

dkepdt2 = M_gauss * acc2; 
smadot2 = dkepdt2(1,:); 
smadot2_mean = CL_mean(smadot2, meth = "trap");

UNIT = 1 / 86400;
scf() 
plot(t, smadot / UNIT, "r"); 
plot(t, smadot_mean * ones(t) / UNIT, "r", "thickness", 2); 
plot(t, smadot2 / UNIT, "b"); 
plot(t, smadot2_mean * ones(t) / UNIT, "b", "thickness", 2); 
xtitle("Decrease rate of semi major axis (m/day)"); 
CL_g_legend(gca(), ["variable", "variable (mean)", "constant", "constant (mean)"]); 
CL_g_stdaxes();

printf('Winding up. . .\nThank you\n')
