//Bohr's atomic model has been used in the program

//Bohr's Postulates
//1.The electron is able to revolve in certain stable orbits, called Bohr Orbits around the nucleus without radiating any energy
//2.The stationary orbits are attained at distances for which the angular momentum of the revolving electron is an integer multiple of the reduced Planck constant
//3.Electrons can only gain and lose energy by jumping from one allowed orbit to another, absorbing or emitting electromagnetic radiation

//Bohr's Assumptions
//1.Quantisation of angular momentum
//m*v*r = nh/(2*pi)
//where
//m=mass of electron
//v=speed of electron
//r=radius of the orbit
//h=Plank constant
//2.The electron is held in a circular orbit by electrostatic attraction. The centripetal force is equal to the Coulomb force.

//Speed of light
c=299792458;
printf('\n----------Welcome to the Scilab Code----------\n')

function x=%s_c_c(a, b)
    x = [string(a),b];
endfunction

// Dictionary containing atomic numbers and corresponding element names
elements = [
    1, 'Hydrogen'; 2, 'Helium'; 3, 'Lithium'; 4, 'Beryllium'; 5, 'Boron';
    6, 'Carbon'; 7, 'Nitrogen'; 8, 'Oxygen'; 9, 'Fluorine'; 10, 'Neon';
    11, 'Sodium'; 12, 'Magnesium'; 13, 'Aluminum'; 14, 'Silicon'; 15, 'Phosphorus';
    16, 'Sulfur'; 17, 'Chlorine'; 18, 'Argon'; 19, 'Potassium'; 20, 'Calcium';
    21, 'Scandium'; 22, 'Titanium'; 23, 'Vanadium'; 24, 'Chromium'; 25, 'Manganese';
    26, 'Iron'; 27, 'Cobalt'; 28, 'Nickel'; 29, 'Copper'; 30, 'Zinc';
    31, 'Gallium'; 32, 'Germanium'; 33, 'Arsenic'; 34, 'Selenium'; 35, 'Bromine';
    36, 'Krypton'; 37, 'Rubidium'; 38, 'Strontium'; 39, 'Yttrium'; 40, 'Zirconium';
    41, 'Niobium'; 42, 'Molybdenum'; 43, 'Technetium'; 44, 'Ruthenium'; 45, 'Rhodium';
    46, 'Palladium'; 47, 'Silver'; 48, 'Cadmium'; 49, 'Indium'; 50, 'Tin';
    51, 'Antimony'; 52, 'Tellurium'; 53, 'Iodine'; 54, 'Xenon'; 55, 'Cesium';
    56, 'Barium'; 57, 'Lanthanum'; 58, 'Cerium'; 59, 'Praseodymium'; 60, 'Neodymium';
    61, 'Promethium'; 62, 'Samarium'; 63, 'Europium'; 64, 'Gadolinium'; 65, 'Terbium';
    66, 'Dysprosium'; 67, 'Holmium'; 68, 'Erbium'; 69, 'Thulium'; 70, 'Ytterbium';
    71, 'Lutetium'; 72, 'Hafnium'; 73, 'Tantalum'; 74, 'Tungsten'; 75, 'Rhenium';
    76, 'Osmium'; 77, 'Iridium'; 78, 'Platinum'; 79, 'Gold'; 80, 'Mercury';
    81, 'Thallium'; 82, 'Lead'; 83, 'Bismuth'; 84, 'Polonium'; 85, 'Astatine';
    86, 'Radon'; 87, 'Francium'; 88, 'Radium'; 89, 'Actinium'; 90, 'Thorium';
    91, 'Protactinium'; 92, 'Uranium'; 93, 'Neptunium'; 94, 'Plutonium'; 95, 'Americium';
    96, 'Curium'; 97, 'Berkelium'; 98, 'Californium'; 99, 'Einsteinium'; 100, 'Fermium';
    101, 'Mendelevium'; 102, 'Nobelium'; 103, 'Lawrencium'; 104, 'Rutherfordium'; 105, 'Dubnium';
    106, 'Seaborgium'; 107, 'Bohrium'; 108, 'Hassium'; 109, 'Meitnerium'; 110, 'Darmstadtium';
    111, 'Roentgenium'; 112, 'Copernicium'; 113, 'Nihonium'; 114, 'Flerovium'; 115, 'Moscovium';
    116, 'Livermorium'; 117, 'Tennessine'; 118, 'Oganesson'
];

// Function to get element name from atomic number
function element_name = getElementName(z)
    index = find(elements(:, 1) == string(z));
    if isempty(index)
        element_name = 'Element not in range (1,118) of atomic numbers';
    else
        element_name = elements(index, 2);
    end
endfunction

// Main program
z=int(input("Enter the tentative atomic number (0 to quit): "));
sq=z*z;
zee=z;
while z<=118 & z~=1
    if z == 0 then
        printf('Exiting...');
        break;
    elseif z < 0 then
        printf('Atomic number cannot be negative.');
    else
        element_name = getElementName(z);
        printf('The element that already exists with atomic number '+string(z)+' is: '+ string(element_name));
    end
    z=int(input("Enter the tentative atomic number (0 to quit): "));
end

//Function to calculate time period of 1 revolution for the electron.
function[]=Time_period(n,z)
    tn=n;
    r=52.9*(n*n)/z;
    v=c*z/(n*1.376);
    T=2*%pi*r/v;
    printf('\nTime period of the revolution (in picoseconds) is:\n')
    printf(string(T)+" ps")
endfunction

//Function to calculate kinetic energy.
function[]=Kinetic_Energy(n,z)
    E=13.6*(z*z)/(n*n);
    printf("Kinetic Energy (in electronvolts) is ")
    printf(string(E)+" eV")
endfunction

//Function to calculate potential energy.
function[]=Potential_Energy(n,z)
    E=-(2*13.6)*(z*z)/(n*n);
    printf("Potential Energy (in electronvolts) is ")
    printf(string(E)+" eV")
endfunction

//For transition energy.
function[]=Energy_of_transition(a,b)
    delE=13.6*sq*((1/(a**2))-(1/(b**2)));
    printf("Positive energy change means that the electron absorbs energy, while negative energy change implies a release of energy")
    printf('\nEnergy of the photon is: ')
    printf(string(delE)+" eV")
endfunction

if z>118 | z==1 then
    if z==1 then
        disp('It is Hydrogen atom')
    end
    
    if z~=1 then
        //Neutron to proton ratio
        A = int(input("Atomic mass of the element in amu: "))
        ratio = (A-z)/z;
        printf('\nHeavy metals are radioactive.\n')
        if ratio > 1.58 then
            printf("Negative electron (beta) decay is expected from nucleus.")
        elseif ratio < 1.0 then
            printf("Nucleus is expected to undergo electron capture or positron emission.")
        else
            printf("Stable isotope.")
        end
    end
    n=int(input("Principle quantum number of interest [any integer > 0]: "));
    if n>0 then
        sqn=n*n;
        pqn=n;
        printf("Which quantity is to be simulated ? ");
        parameter=input('velocity, radius or total energy [Enter 0 to exit]: ','string')
        while parameter~="0"
            if parameter=="radius" then
                r=52.9*sqn/z;
                printf("Radius (in picometres) is: ")
                printf(string(r)+" pm")
                printf('\nEnter 0 to exit\n')
                xaxis=input('Plotting its graph, which quantity is to be kept on x axis, n or z? ', 'string')
                while xaxis~="0"
                    if xaxis=="n" then
                        //Function to plot variation of radius with principal quantum number.
                        function r=plotrad(n)  
                            r=52.9*n*n/zee;
                        endfunction
                        n=int(linspace(1,100,100));
                        plot(n,plotrad,"*g")
                        xlabel "n"
                        ylabel "radius(in pm)"
                    else
                        function r=plotrad1(z)  
                            r=52.9*sqn/z;
                        endfunction
                        z=int(linspace(1,100,100));
                        plot(z,plotrad1,"om")
                        plot(z,plotrad1,"k")
                        xlabel "z"
                        ylabel "radius(in pm)"
                    end
                    printf('\nEnter 0 to exit\n')
                    xaxis=input('Plotting on graph, which quantity is to be kept on x axis, n or z? ', 'string')
                end
    
            elseif parameter=="velocity" then
                v=c*z/(n*1.376);
                printf("Velocity of electron (in SI Units) is: ")
                printf(string(v)+" m/s")
                printf('\nEnter 0 to exit\n')
                xaxis=input('Plotting its graph, which quantity is to be kept on x axis, n or z? ', 'string')
                while xaxis~="0"
                    if xaxis=="n" then 
                        //Function to plot variation of velocity with n
                        function v=plotvel(n)
                             v=c*z*(10**(-6))/(n*1.376);
                        endfunction
                        nvel=int(linspace(1,100,100));
                        plot(nvel,plotvel,"k")
                        xlabel "n"
                        ylabel "velocity (in 10^6 m/s)"
                        xgrid(10,1,7)
                    else
                        //Function to plot variation of velocity with z
                        function v1=plotvel1(z)
                            
                            v1=c*z*(10**(-6))/(n*1.376);
                        endfunction
                        zvel=int(linspace(1,100,100));
                        plot(zvel,plotvel1)
                        xlabel "z"
                        ylabel "velocity (in 10^6 m/s)"
                        xgrid(10,1,7)
                    end
                    printf('\nEnter 0 to exit\n')
                    xaxis=input('Plotting on graph, which quantity is to be kept on x axis, n or z? ','string')
                end
    
            elseif parameter=="total energy" then
                E=-13.6*(sq)/(sqn);
                printf("Total energy in electronvolts is: ")
                printf(string(E)+" eV")
                if pqn==1 & z==1 then
                    printf('\nThis is Ionisation Energy of the element.\n')
                end
                printf('\nEnter 0 to exit\n')
                xaxis=input('Plotting its graph, which quantity is to be kept on x axis, n or z? ', 'string')
                while xaxis~="0"
                    if xaxis=="n" then 
                        //Function to plot variation of total energy with n
                        function E=ploten(n)
                            E=-13.6*(sq)/(n*n);
                        endfunction
                        n=int(linspace(1,100,100));
                        plot(n,ploten,"y")
                        plot(n,ploten,".y")
                        xlabel "n"
                        ylabel "total energy(in eV)"
                            xgrid(10,1,7)
                    else
                        //Function to plot variation of total energy with z
                        function E=ploten1(z)
                            E=-13.6*(z*z)/(sqn);
                        endfunction
                        z=int(linspace(1,100,100));
                        plot(z,ploten1,"r")
                        plot(z,ploten1,".r")
                        xlabel "z"
                        ylabel "total energy (in eV)"
                        xgrid(10,1,7)
                    end
                    printf('\nEnter 0 to exit\n')
                    xaxis=input('Plotting on graph, which quantity is to be kept on x axis, n or z?: ', 'string')
                end
            end
        parameter=input('velocity, radius or total energy [Enter 0 to exit]: ','string');
        end

        printf('\nFor the simulation of following physical quantities, numerical codes have been designated\n\nEnergy released or absorbed by the electron in the\nform of photon while undergoing transition        : 1\nPeriod of revolution of electron in nth Bohr orbit: 2\nKinetic energy of the electron                    : 3\nPotential energy of the electron                  : 4\nTo exit                                           : 0\n\n')

        zetta=int(input("Enter a number: "));
        while zetta~=0
            if zetta == 1 then
                printf('For calculation of the energy of transition')
                from1 = int(input("Principal quantum number, from which transition happens [enter a natural number]: "));
                to1 = int(input("Principal quantum number, to which transition happens [enter a natural number]: "));
                Energy_of_transition(from1,to1)
            elseif zetta == 2 then
                Time_period(n,z)
            elseif zetta == 3 then
                Kinetic_Energy(n,z)
            elseif zetta == 4 then
                Potential_Energy(n,z)
            else
                printf('Please enter an appropriate number\n')
            end
            
            zetta=int(input("Enter a number for the quantity of interest (in range [0,4]): "));
        end
    else
        printf('Principal quantum number is a natural number')
    end
end
disp('Winding up...Thank you')
