// This GUI file is generated by guibuilder version 4.2.2
//////////
f=figure('figure_position',[-8,-8],'figure_size',[1552,832],'auto_resize','on','background',[34],'figure_name','Graphic window number %d','color_map',[0,0,0;0,0,1;0,1,0;0,1,1;1,0,0;1,0,1;1,1,0;1,1,1;0,0,0.5647059;0,0,0.6901961;0,0,0.8156863;0.5294118,0.8078431,1;0,0.5647059,0;0,0.6901961,0;0,0.8156863,0;0,0.5647059,0.5647059;0,0.6901961,0.6901961;0,0.8156863,0.8156863;0.5647059,0,0;0.6901961,0,0;0.8156863,0,0;0.5647059,0,0.5647059;0.6901961,0,0.6901961;0.8156863,0,0.8156863;0.5019608,0.1882353,0;0.627451,0.2509804,0;0.7529412,0.3764706,0;1,0.5019608,0.5019608;1,0.627451,0.627451;1,0.7529412,0.7529412;1,0.8784314,0.8784314;1,0.8431373,0;0.8,0.8,0.8;0.9333333,0.9333333,0.9333333],'dockable','off','infobar_visible','off','toolbar_visible','off','menubar_visible','off','default_axes','on','visible','off');
//////////
handles.dummy = 0;
handles.frame=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.249349,0.1202513,0.5507812,0.7792462],'Relief','default','SliderStep',[0.01,0.1],'String','UnName1','Style','frame','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','frame','Callback','')
handles.text1=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.279401,0.6951256,0.1045573,0.0351759],'Relief','default','SliderStep',[0.01,0.1],'String','Fixed End Diameter (m)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text1','Callback','')
handles.text2=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.4013455,0.6951256,0.1345573,0.0351759],'Relief','default','SliderStep',[0.01,0.1],'String','Free End Diameter (m)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text2','Callback','')
handles.text3=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5315451,0.6951256,0.1345573,0.0351759],'Relief','default','SliderStep',[0.01,0.1],'String','Column Length (m)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text3','Callback','')
handles.text4=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.6471354,0.6951256,0.1345573,0.0351759],'Relief','default','SliderStep',[0.01,0.1],'String','Number of Nodes','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text4','Callback','')
handles.fixenddia=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.2792318,0.6558291,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','fixenddia','Callback','')
handles.freeenddia=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.4023785,0.6558291,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','freeenddia','Callback','')
handles.columnlength=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.531072,0.6558291,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','columnlength','Callback','')
handles.nodecount=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.6471354,0.6558291,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','nodecount','Callback','')
handles.text5=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.2792969,0.5870854,0.1045573,0.0414573],'Relief','default','SliderStep',[0.01,0.1],'String','Point Load (N)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text5','Callback','')
handles.text6=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.4013455,0.5921106,0.1345573,0.0288945],'Relief','default','SliderStep',[0.01,0.1],'String','Surface Traction (N/m^2)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text6','Callback','')
handles.text7=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5301302,0.5908543,0.0917969,0.0288945],'Relief','default','SliderStep',[0.01,0.1],'String','Body Force (N/m^3)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text7','Callback','')
handles.text8=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.6460156,0.5908543,0.1361198,0.0288945],'Relief','default','SliderStep',[0.01,0.1],'String','Modulus of Elasticity (N/m^2)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text8','Callback','')
handles.pointload=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.2792318,0.5533668,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','pointload','Callback','')
handles.surftrac=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.4023785,0.5533668,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','surftrac','Callback','')
handles.bodyforce=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.531072,0.5533668,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','bodyforce','Callback','')
handles.modulus=uicontrol(f,'unit','normalized','BackgroundColor',[-1,-1,-1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.6458333,0.5533668,0.0938542,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','edit','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','modulus','Callback','')
handles.solvebtn=uicontrol(f,'unit','normalized','BackgroundColor',[1,1,0.2],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[18],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3345443,0.4720603,0.3903906,0.0427136],'Relief','default','SliderStep',[0.01,0.1],'String','Provide the Solution','Style','pushbutton','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','solvebtn','Callback','solvebtn_callback(handles)')
handles.outputframe=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','normal','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.2863802,0.161608,0.4867188,0.2875377],'Relief','default','SliderStep',[0.01,0.1],'String','UnName19','Style','frame','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','outputframe','Callback','')
handles.output=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[25],'FontUnits','points','FontWeight','bold','ForegroundColor',[1,1,0],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.4421745,0.378392,0.1751302,0.0452261],'Relief','default','SliderStep',[0.01,0.1],'String','Outputs','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','output','Callback','')
handles.elementlength=uicontrol(f,'unit','normalized','BackgroundColor',[1,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3107812,0.3006748,0.1790104,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','elementlength','Callback','')
handles.columnavgstress=uicontrol(f,'unit','normalized','BackgroundColor',[1,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5407812,0.3006748,0.1790104,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','columnavgstress','Callback','')
handles.columnavgstrain=uicontrol(f,'unit','normalized','BackgroundColor',[1,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3107812,0.2124695,0.1790104,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','columnavgstrain','Callback','')
handles.columnavgload=uicontrol(f,'unit','normalized','BackgroundColor',[1,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[-1,-1,-1],'HorizontalAlignment','left','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5407812,0.2121106,0.1790104,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String',' ','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','columnavgload','Callback','')
handles.text9=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[14],'FontUnits','points','FontWeight','bold','ForegroundColor',[1,1,0],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3501562,0.3408543,0.1002604,0.0301508],'Relief','default','SliderStep',[0.01,0.1],'String','Element Length (m)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text9','Callback','')
handles.text10=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[13],'FontUnits','points','FontWeight','bold','ForegroundColor',[1,1,0],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5428776,0.3404954,0.1748177,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String','Column Average Stress (N/m^2)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text10','Callback','')
handles.text11=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[12],'FontUnits','points','FontWeight','bold','ForegroundColor',[1,1,0],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3400651,0.252649,0.1204427,0.031407],'Relief','default','SliderStep',[0.01,0.1],'String','Column Average Strain','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text11','Callback','')
handles.text12=uicontrol(f,'unit','normalized','BackgroundColor',[0,0.4,0.3],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[13],'FontUnits','points','FontWeight','bold','ForegroundColor',[1,1,0],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.5607161,0.2522901,0.1391406,0.0339196],'Relief','default','SliderStep',[0.01,0.1],'String','Column Average Load (N)','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','text12','Callback','')
handles.header=uicontrol(f,'unit','normalized','BackgroundColor',[0,1,1],'Enable','on','FontAngle','normal','FontName','Tahoma','FontSize',[25],'FontUnits','points','FontWeight','bold','ForegroundColor',[0,0,1],'HorizontalAlignment','center','ListboxTop',[],'Max',[1],'Min',[0],'Position',[0.3496094,0.8360302,0.3502604,0.0364322],'Relief','default','SliderStep',[0.01,0.1],'String','Uniaxial Column 1D FEM Analysis','Style','text','Value',[0],'VerticalAlignment','middle','Visible','on','Tag','header','Callback','')


f.visible = "on";


//////////
// Callbacks are defined as below. Please do not delete the comments as it will be used in coming version
//////////

function [displacement, stress, strain, avg_load,col_avg_stress,col_avg_strain,col_avg_load] = perform_fem_analysis(L, d_fixed, d_free, P, s, b, E, n_nodes)
    
    //Initialize variables
    n_elements = n_nodes - 1;
    element_length = L / n_elements;
    
    //Node coordinates
    x = linspace(0, L, n_nodes);
    
    //Cross-sectional areas (linear variation for tapered column)
    A_fixed = %pi * (d_fixed/2)^2;
    A_free = %pi * (d_free/2)^2;
    A = A_fixed + (A_free - A_fixed) * (x / L);
    
   //Initialize global stiffness matrix and force vector
    K_global = zeros(n_nodes, n_nodes);
    F_global = zeros(n_nodes, 1);
    
    //Element stiffness matrix assembly
    for i = 1:n_elements
        //Element properties
        A_e = (A(i) + A(i+1)) / 2;  //Average area
        L_e = element_length;
        
        //Element stiffness matrix
        K_e = (E * A_e / L_e) * [1 -1; -1 1];
        
        //Surface traction and body force contributions
        f_s = s * %pi * sqrt(A_e/%pi) * L_e / 2;
        f_b = b * A_e * L_e / 2;
        
        //Element force vector
        F_e = [f_s + f_b; f_s + f_b];
        
        //Global assembly
        dof = [i, i+1];
        K_global(dof, dof) = K_global(dof, dof) + K_e;
        F_global(dof) = F_global(dof) + F_e;
    end
    
    //Apply point load at free end
    F_global(n_nodes) = F_global(n_nodes) + P;
    
    //Apply boundary conditions (fixed end)
    K_global(1, :) = 0;
    K_global(1, 1) = 1;
    F_global(1) = 0;
    
    //Solve for displacements
    displacement = K_global \ F_global;
    
    //Calculate element stresses and strains
    stress = zeros(n_elements, 1);
    strain = zeros(n_elements, 1);
    avg_load = zeros(n_elements, 1);
    
    strainsum=0;
    stresssum=0;
    
    for i = 1:n_elements
        //Element displacement
        u_e = displacement([i, i+1]);
        
        //Element strain
        strain(i) = (u_e(2) - u_e(1)) / element_length;
        
        //Element stress
        stress(i) = E * strain(i);
        
        //Element average load
        avg_load(i) = P;
        
        
       strainsum=strainsum+strain(i);
       stresssum=stresssum+stress(i);
       
        
    end
    
    col_avg_load=P;
    col_avg_stress=stresssum/n_elements;
    col_avg_strain=strainsum/n_elements;

    // Strain Plot
    x_mid = zeros(n_elements, 1);
    for i = 1:n_elements
        x_mid(i) = (x(i) + x(i+1)) / 2;
    end

    x_interp = linspace(0, L, 200);
    strain_interp = interp1(x_mid, strain, x_interp, "linear");

    scf(); // Strain figure
    plot2d(x_interp, strain_interp,style=color("indianred"));
    plot(x_mid, strain, 'ro');           // original stress points
    xlabel("Position along column (x)");
    ylabel("Strain (ε)");
    title("Interpolated Strain Distribution");
    xgrid();

    // Stress Plot
    stress_interp = interp1(x_mid, stress, x_interp, "linear");

    scf(); // Stress figure
    plot(x_interp, stress_interp, '-g');
    plot(x_mid, stress, 'ro');           // original stress points
    xlabel("Position along column (x)");
    ylabel("Stress (σ)");
    title("Interpolated Stress Distribution");
    xgrid();
    
    x_fine = linspace(0, L, 500); // 500 interpolated points
    
    // Interpolate displacements using linear interpolation
    displacement_fine = interp1(x, displacement, x_fine, "linear");
    
    // Plot
    scf();
    plot(x_fine, displacement_fine, 'b-'); // interpolated line
    plot(x, displacement, 'ro');           // original nodal displacements
    xtitle("Interpolated Nodal Displacement", "Length (m)", "Displacement (m)");
    xgrid();
end

function solvebtn_callback(handles)
    fixedDia = strtod(handles.fixenddia.string);
    freeDia = strtod(handles.freeenddia.string);
    columnLength = strtod(handles.columnlength.string);
    nodes = strtod(handles.nodecount.string);
   pointLoad = strtod(handles.pointload.string);
   surfTrac = strtod(handles.surftrac.string);
   bodyForce = strtod(handles.bodyforce.string);
   modulus = strtod(handles.modulus.string);
   
   [displacement, stress, strain, avg_load,col_avg_stress, col_avg_strain,col_avg_load] = perform_fem_analysis(columnLength, fixedDia, freeDia, pointLoad, surfTrac, bodyForce, modulus, nodes+1);
   
  handles.elementlength.string=string(columnLength/(nodes-1));
  handles.columnavgstress.string=string(col_avg_stress);
  handles.columnavgstrain.string=string(col_avg_strain);
  handles.columnavgload.string=string(col_avg_load);

   
//Write your callback for  solvebtn  here

endfunction



