// =============================================
// Surface Defect Analysis - Final Corrected Code
// =============================================

// Suppress function redefinition warnings
funcprot(0);

// Load necessary toolboxes
// --> exec('SCI/modules/astable/etc/astable.start', -1)

// Read input image (Update path)
originalImage = imread('D:\Scilab Hackathon\AutomatedProductSurfaceDefectInspectionUsingScilab\sample_image.jpg');

// Resize image
scalingFactor = 0.5;
resizedImage = imresize(originalImage, scalingFactor);

// Convert to grayscale
grayImage = rgb2gray(resizedImage);

// =============================================
// Manual Otsu's Threshold Implementation
// =============================================
function threshold = otsuThreshold(img)
    hist = imhist(img);
    probabilities = hist/sum(hist);
    variances = zeros(1,256);
    
    for t=1:256
        w0 = sum(probabilities(1:t));
        w1 = 1 - w0;
        if w0 == 0 | w1 == 0 then continue; end
        
        mu0 = sum((0:t-1).*probabilities(1:t)')/w0;
        mu1 = sum((t:255).*probabilities(t+1:$)')/w1;
        variances(t) = w0*w1*(mu0 - mu1)^2;
    end
    threshold = find(variances == max(variances)) - 1;
endfunction

// Calculate threshold
threshold = otsuThreshold(grayImage);

// Create binary mask
binaryMask = grayImage < threshold;

// Morphological operations
if exists('imdilate') == 0 then
    error('Install Image Processing Design (IPD) toolbox');
end

cleanedMask = imerode(binaryMask, ones(3,3));
cleanedMask = imdilate(cleanedMask, ones(5,5));

// Create defect overlay
overlayImage = resizedImage;
redChannel = overlayImage(:,:,1);
greenChannel = overlayImage(:,:,2);
blueChannel = overlayImage(:,:,3);

redChannel(cleanedMask) = 255;
greenChannel(cleanedMask) = 0;
blueChannel(cleanedMask) = 0;
overlayImage = cat(3, redChannel, greenChannel, blueChannel);

// =============================================
// Visualization
// =============================================
figure("Figure_name", "Defect Analysis Results", "position", [0 0 1280 720]);

subplot(2,3,1);
imshow(originalImage);
title("Original Image");

subplot(2,3,2);
imshow(resizedImage);
title("Resized Image (" + string(scalingFactor*100) + "%)");

subplot(2,3,3);
imshow(grayImage);
title("Grayscale Conversion");

subplot(2,3,4);
[counts, bins] = imhist(grayImage);
plot(bins, counts, 'b-');
a = gca();
a.auto_clear = "off";
plot([threshold threshold], [0 max(counts)], 'r--');
title("Intensity Histogram");
xlabel("Pixel Intensity");
ylabel("Count");
legend(["Histogram", "Otsu Threshold"]);

subplot(2,3,5);
imshow(cleanedMask);
title("Cleaned Binary Mask");

subplot(2,3,6);
imshow(overlayImage);
title("Defect Overlay (Red Regions)");

// Display results (Fixed mean calculation)
disp("Otsu Threshold Value: " + string(threshold));
disp("Defect Coverage: " + string(100*mean(double(cleanedMask))) + "%");
