//AIM:Design a five turn helical antenna in the normal mode at 400MHz. 
//Software version Scilab 5.5.2
//OS windows 7
clc;
clear;
//We consider that the spacing between the turns is λ/50 and assume that
//circular polarization is desired.
//We will determine
// 1. Circumference of the helix(in meters)
//2. Length of a single turn
//3. Overall length of the entire helix
//4. Pitch angle in degrees
 
n=5;//Number of turns
f=400*10^6;//Frequency
disp('Hz',f,"Frequency=")
c=3*10^8;//Speed of light
lambda=c/f;//Computing the wavelength
disp('m',lambda,"lambda=");
//Computing the vertical separation (spacing) between the turns
//Spacing(S)=(wavelength)/(No. of turns)
S=lambda/50;
disp('m',S,"Spacing=");
C=sqrt(2*lambda*S);//Circumference
disp('m',C,"Circumference=");
L0=sqrt((S^2)+(C^2));//Length of single turn
disp('m',L0,"Length of single turn (L0)=")
Ln=n*L0;//Overall length
disp('m',Ln,"Overall length(Ln)=")
alpha=atan(S/C);//Pitch angle(in radians)
alpha_degrees=alpha*(180/%pi);//Pitch angle(in degrees)
disp('degrees',alpha_degrees,"Pitch angle=")
