//AIM:Compute the field strength of the incident wave of square loop antenna.
//Software version Scilab 5.5.2
//OS windows 7

clc;
clear;
//Let the square loop antenna have 25 turns and each side of 0.5m. When it
//is tuned to 500 KHz,the maximum emf induced in the loop is 150 uV.

N=25;// Number of turns
l=0.5;//Length of the side of a square loop antenna (in meters)
Vrms=150*(10^-6);// in micro Volts(uV)
f=500*(10^3);//Frequency in Hz
disp('Hz',f,"frequency=")
c=3*10^8;//Speed of light
lambda=c/f;//Computing the value of the wavelength (lambda)
disp('m',lambda,"lambda=")
A=l*l;//area
disp('m^2',A,"Area=")
theta=0;//as emf induced is maximum, the angle theta=0 degree
Erms=(lambda/(2*%pi*A*N*cos(theta)))*Vrms
disp('V/m',Erms,"The field strength of incident wave(Erms)=");
