//Chapter 3
//Example 3_22
//Page 65

clear;clc;

ratio = [7, 4, 1];
lf=1;

//Referring to the graph in page 66

ugpa=1000*(1/2*(320+160)*8760);
steam=ugpa*ratio(1)/sum(ratio);
ror=ugpa*ratio(2)/sum(ratio);
reservoir=ugpa*ratio(3)/sum(ratio);

md_ror=ror/8760;
y=sqrt(reservoir*32/876000);
md_res=y;
md_steam=320-y-md_ror/1000;
lf_res=reservoir/md_res/1000/8760;
lf_steam=steam/md_steam/1000/8760;

printf("Units generated per annum = %.2f*10^6 kW \n\n", ugpa/10^6);
printf("Units generated by steam plant = %.2f*10^6 kWh \n", steam/10^6);
printf("Units generated by run of river plant = %.2f*10^6 kWh \n", ror/10^6);
printf("Units generated by reservoir plant = %.2f*10^6 kWh \n\n", reservoir/10^6);

printf("(i) Maximum demand of run of river plant = %d kW \n", md_ror);
printf("    Maximum demand of reservoir plant = %d MW \n", md_res);
printf("    Maximum demand of steam plant = %d MW \n\n", md_steam);

printf("(ii) Load factor of run of river plant = %d %% \n", lf*100);
printf("     Load factor of reservoir plant = %d %% \n", lf_res*100);
printf("     Load factor of steam plant = %.2f %% \n", lf_steam*100);






